% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_triggers.R
\name{extract_triggers}
\alias{extract_triggers}
\alias{extract_triggers.data.frame}
\alias{extract_triggers.eyelinkRecording}
\title{Extract triggers, a custom message type}
\usage{
extract_triggers(object, message_prefix = "TRIGGER")

\method{extract_triggers}{data.frame}(object, message_prefix = "TRIGGER")

\method{extract_triggers}{eyelinkRecording}(object, message_prefix = "TRIGGER")
}
\arguments{
\item{object}{Either an \code{\link{eyelinkRecording}} object or data.frame with events,
i.e., \code{events} slot of the \code{\link{eyelinkRecording}} object.}

\item{message_prefix}{Beginning of the message string that identifies trigger messages.
Defaults to \code{"TRIGGER"}.}
}
\value{
Object of the same time as input, i.e., either a \code{\link{eyelinkRecording}} object
with an additional \code{triggers} slot or a data.frame with triggers' information. See
\code{\link{eyelinkRecording}} for details.
}
\description{
Extracts trigger events, messages that adhere to a
\code{<message_prefix> <label>} format. Their purpose is to identify the time
instance of specific interest.
Please note that due to a non-standard nature of this function \strong{is not} called
during the \code{\link{read_edf}} call and you need to call it separately.
}
\examples{
data(gaze)

# by passing the recording
gaze <- extract_triggers(gaze)

# by passing events table
triggers <- extract_triggers(gaze$events)

# with an explicit message prefix
triggers <- extract_triggers(gaze$events, "TRIGGER")
}
\seealso{
read_edf, eyelinkRecording
}
