% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/va_cleaner.R
\name{clean_va}
\alias{clean_va}
\alias{cleanVA}
\title{Cleaning up Visual acuity entries}
\usage{
clean_va(x, quali = c("nlp", "lp", "hm", "cf"), message = TRUE)

cleanVA(x, quali = c("nlp", "lp", "hm", "cf"), message = TRUE)
}
\arguments{
\item{x}{Vector with VA entries}

\item{quali}{strings for qualitative visual acuity entries}

\item{message}{message for replaced NA values}
}
\value{
character vector
}
\description{
VA cleaning:
\enumerate{
\item \link{tidyNA}:
Replacing empty placeholders (".","", "(any number of empty space)",
"NULL", "NA", "N/A" , "-") - any cases - with NA
\item Simplifying the notation for qualitative
VA notation (NPL becomes NLP, PL becomes LP)
\item Removing non-Snellen character strings
}
}
\seealso{
Other VA cleaner: 
\code{\link{va}()}
}
\concept{VA cleaner}
