% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAclassConversion.R
\name{VAwrapper}
\alias{VAwrapper}
\alias{to_logmar}
\alias{to_etdrs}
\alias{to_snellen}
\alias{as_logmar}
\alias{as_etdrs}
\alias{as_snellen}
\title{VA conversion wrapper}
\usage{
to_logmar(x, ...)

to_etdrs(x, ...)

to_snellen(x, ...)

as_logmar(x, ...)

as_etdrs(x, ...)

as_snellen(x, ...)
}
\arguments{
\item{x}{vector of visual acuities}

\item{...}{parameters passed to \link{va}}
}
\value{
vector with visual acuity of class as_(...) or to_(...)
See also \link{convertVA}: "VA classes"
}
\description{
Simple convenience wrapper around \link{va} to get desired VA class
}
\section{VA conversion}{

For details see \link{va} and \link{convertVA}
}

\examples{
x <- c(23, 56, 74, 58) ## ETDRS letters
to_logmar(x)
to_snellen(x)
to_snellen(x, type = "dec")

x <- c("NLP", "0.8", "34", "3/60", "2/200", "20/50", "  ", ".", "-", "NULL")
to_snellen(x, from = "snellendec")
to_snellen(x, from = "etdrs")
to_snellen(x, from = "logmar")
}
\seealso{
Other VA converter: 
\code{\link{plausibility_methods}},
\code{\link{snellen_steps}},
\code{\link{va_methods}},
\code{\link{va_mixed}()},
\code{\link{va}()},
\code{\link{which_va}()}
}
\concept{VA converter}
