% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{bootCI.ts}
\alias{bootCI.ts}
\title{Pointwise confidence intervals by bootstrap}
\usage{
bootCI.ts(
  X,
  t,
  Tgrid,
  h,
  kernel = TruncGauss.kernel,
  kpar = NULL,
  prob = 0.99,
  threshold = quantile(X, 0.99),
  B = 100,
  alpha = 0.05,
  type = "quantile",
  CritVal = 3.6,
  initprop = 1/10,
  gridlen = 100,
  r1 = 1/4,
  r2 = 1/20,
  plot = F
)
}
\arguments{
\item{X}{a vector of the observed values.}

\item{t}{a vector of time covariates which should have the same length as X.}

\item{Tgrid}{a sequence of times used to perform the cross validation (can be any sequence in the interval \code{[min(t) , max(t)]} ).}

\item{h}{a bandwidth value (vector values are not admitted).}

\item{kernel}{a kernel function used to compute the weights in the time domain, with default the truncated gaussian kernel.}

\item{kpar}{a value for the kernel function parameter, with no default value.}

\item{prob}{used if type = "quantile", a scalar value in \eqn{[0,1]} which determines the quantile order (vector values are not admitted).}

\item{threshold}{used if type = "survival", a scalar value in the domain of X.}

\item{B}{an integer giving the number of bootstrap iterations.}

\item{alpha}{the type 1 error of the bootstrap (1-\eqn{alpha})-confidence interval.}

\item{type}{type is either "quantile" or "survival".}

\item{CritVal}{a critical value associated to the kernel function given by \code{\link{CriticalValue}}. The default value is 3.6 corresponding to the truncated Gaussian kernel.}

\item{gridlen, initprop, r1, r2}{parameters used in the function hill.adapt (see \code{\link{hill.adapt}}).}

\item{plot}{If \code{TRUE}, the bootstrap confidence interval is plotted.}
}
\value{
\item{LowBound}{the lower bound of the bootstrap (1-\eqn{alpha})-confidence interval.}
\item{UppBound}{the upper bound of the bootstrap (1-\eqn{alpha})-confidence interval of level.}
}
\description{
Pointwise quantiles and survival probabilities confidence intervals using bootstrap.
}
\details{
For each point in \eqn{Tgrid}, generate B samples of \eqn{X} with replacement to estimate the quantile of order \eqn{prob} or the survival probability beyond \eqn{threshold}. Determine the bootstrap pointwise (1-\eqn{alpha})-confidence interval for the quantiles or the survival probabilities.

The kernel implemented in this packages are : Biweight kernel, Epanechnikov kernel, Rectangular kernel, Triangular kernel and the truncated Gaussian kernel.
}
\section{Warning}{

The executing time of the function can be time consuming if the B parameter or the sample size are high (B=100 and the sample size = 5000 for example) .
}

\examples{
theta <- function(t){
   0.5+0.25*sin(2*pi*t)
 }
n <- 5000
t <- 1:n/n
Theta <- theta(t)
set.seed(123)
Data <- NULL
for(i in 1:n){
   Data[i] <- rparetomix(1, a = 1/Theta[i], b = 1/Theta[i]+5, c = 0.75)
 }
Tgrid <- seq(1, length(Data)-1, length = 20)/n
h <- 0.1
\dontrun{ #For computing time purpose
  bootCI.ts(Data, t, Tgrid, h, kernel = TruncGauss.kernel, kpar = c(sigma = 1),
            CritVal = 3.6, threshold = 2, type = "survival", B = 100, plot = TRUE)
  true.p <- NULL
  for(i in 1:n){
     true.p[i] <- 1-pparetomix(2, a = 1/Theta[i], b = 1/Theta[i]+5, c = 0.75)
   }
  lines(t, true.p, col = "red")
  bootCI.ts(Data, t, Tgrid, h, kernel = TruncGauss.kernel, kpar = c(sigma = 1),
 prob = 0.999, type = "quantile", B = 100, plot = TRUE)
  true.quantile <- NULL
  for(i in 1:n){
     true.quantile[i] <- qparetomix(0.999, a = 1/Theta[i], b = 1/Theta[i]+5, c = 0.75)
   }
  lines(t, log(true.quantile), col = "red")
}


}
\seealso{
\code{\link{hill.ts}},\code{\link{predict.hill.ts}}, \code{\link{Biweight.kernel}}, \code{\link{Epa.kernel}}, \code{\link{Rectangular.kernel}}, \code{\link{Triang.kernel}}, \code{\link{TruncGauss.kernel}}
}
