% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{plot.hill}
\alias{plot.hill}
\title{Hill Plot}
\usage{
\method{plot}{hill}(x, xaxis = "ranks", ...)
}
\arguments{
\item{x}{output object of the function hill.}

\item{xaxis}{either "ranks" or "xsort".}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Graphical representation of the hill estimator.
}
\details{
If xaxis="ranks", the function draws the Hill estimators for each ranks of the grid output of the function hill.
If xaxis="xsort", the function draws the Hill estimators for each data of the grid output of the function hill.
}
\examples{
x <- abs(rcauchy(100))
hh <- hill(x)
par(mfrow = c(2, 1))
plot(hh, xaxis = "ranks")
plot(hh, xaxis = "xsort")

}
\seealso{
\code{\link{hill}}
}

