% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLfit.R
\name{plotLfit}
\alias{plotLfit}
\title{Plot distributions fitted with L-moments}
\usage{
plotLfit(
  dlf,
  nbest = 5,
  selection = NULL,
  order = TRUE,
  rmse = 4,
  cdf = FALSE,
  log = FALSE,
  supportends = TRUE,
  breaks = 20,
  xlim = extendrange(dlf$dat, f = 0.15),
  ylim = NULL,
  col = "grey",
  main = paste(if (cdf) "Cumulated", "density distributions of", dlf$datname),
  xlab = dlf$datname,
  ylab = if (cdf) "(Empirical) Cumulated Density (CDF)" else
    "Probability Density Function (PDF)",
  las = 1,
  distcols = berryFunctions::rainbow2(nbest),
  lty = 1,
  add = FALSE,
  logargs = NULL,
  legend = TRUE,
  legargs = NULL,
  histargs = NULL,
  ...
)
}
\arguments{
\item{dlf}{List as returned by \code{\link{distLfit}}, containing the
elements \code{dat, parameter, gof, datname}}

\item{nbest}{Number of distributions plotted, in order of goodness of fit.
DEFAULT: 5}

\item{selection}{Names of distributions in \code{dlf$parameter} that will be drawn.
Overrides nbest. DEFAULT: NULL}

\item{order}{Logical: order legend and colors by RMSE, even if dlf$gof is
unordered or selection is given? DEFAULT: TRUE}

\item{rmse}{Integers. If rmse != 0, RMSE values are added to legend.
They are rounded to \code{rmse} digits. DEFAULT: 4}

\item{cdf}{If TRUE, plot cumulated DF instead of probability density.
DEFAULT: FALSE}

\item{log}{If TRUE, \code{berryFunctions::\link[berryFunctions]{logAxis}} is called. Only makes sense if dlf$dat is
already logarithmic and ranges eg. from -2 to 3. DEFAULT: FALSE}

\item{supportends}{If TRUE, dots are placed at the support bounds. DEFAULT: TRUE}

\item{breaks}{\code{\link{hist}} breaks. DEFAULT: 20}

\item{xlim, ylim}{\code{\link{hist}} or \code{\link{ecdf}} axis limits.}

\item{col}{\code{\link{hist}} bar color or \code{\link{ecdf}} point color.
DEFAULT: "grey"}

\item{main, xlab, ylab}{\code{\link{hist}} or \code{\link{ecdf}} main, xlab, ylab.
DEFAULT: abstractions from \code{dlf$datname}}

\item{las}{Label Axis Style for orientation of numbers along axes. DEFAULT: 1}

\item{distcols}{Color for each distribution added with \code{\link{lines}}.
DEFAULT: \code{berryFunctions::\link[berryFunctions]{rainbow2}}}

\item{lty}{Line TYpe for plotted distributions.
Recycled vector of length nbest. DEFAULT: 1}

\item{add}{If TRUE, hist/ecdf is not called before adding lines.
This lets you add lines highly customized one by one.
DEFAULT: FALSE}

\item{logargs}{List of arguments passed to \code{berryFunctions::\link[berryFunctions]{logAxis}} if
\code{log=TRUE}. DEFAULT: NULL}

\item{legend}{Should \code{\link{legend}} be called? DEFAULT: TRUE}

\item{legargs}{List of arguments passed to \code{\link{legend}} except for
legend and col. DEFAULT: NULL}

\item{histargs}{List of arguments passed to \code{\link{hist}} or \code{\link{ecdf}}
except for x, freq. DEFAULT: NULL}

\item{\dots}{Further arguments passed to \code{\link{lines}}, like type, pch, ...}
}
\value{
invisible dlf object, see \code{\link{printL}}
}
\description{
Plot histogram and distribution densities \emph{or} ecdf with cumulated probability
}
\details{
By default, this plots density instead of CDF, because the distributions are
easier to discern and tail behavior is easier to judge visually.
}
\examples{
 # See distLfit

}
\seealso{
\code{\link{distLfit}}, \code{\link{plotLquantile}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Sept 2014
}
\keyword{distribution}
\keyword{hplot}
