% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncated-binomial-distribution.R
\name{TruncBinom}
\alias{TruncBinom}
\alias{dtbinom}
\alias{ptbinom}
\alias{qtbinom}
\alias{rtbinom}
\title{Truncated binomial distribution}
\usage{
dtbinom(x, size, prob, a = -Inf, b = Inf, log = FALSE)

ptbinom(q, size, prob, a = -Inf, b = Inf, lower.tail = TRUE,
  log.p = FALSE)

qtbinom(p, size, prob, a = -Inf, b = Inf, lower.tail = TRUE,
  log.p = FALSE)

rtbinom(n, size, prob, a = -Inf, b = Inf)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{size}{number of trials (zero or more).}

\item{prob}{probability of success on each trial.}

\item{a, b}{lower and upper truncation points (\code{a < x <= b}).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the truncated binomial distribution.
}
\examples{

x <- rtbinom(1e5, 100, 0.83, 76, 86)
xx <- seq(0, 100)
plot(prop.table(table(x)))
lines(xx, dtbinom(xx, 100, 0.83, 76, 86), col = "red")
hist(ptbinom(x, 100, 0.83, 76, 86))

xx <- seq(0, 100, by = 0.01)
plot(ecdf(x))
lines(xx, ptbinom(xx, 100, 0.83, 76, 86), col = "red", lwd = 2)
uu <- seq(0, 1, by = 0.001)
lines(qtbinom(uu, 100, 0.83, 76, 86), uu, col = "blue", lty = 2)

}
\keyword{distribution}
