% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_expExtract.R
\name{expExtract}
\alias{expExtract}
\title{Extract statistically equivalent methods from a multiple comparison test}
\usage{
expExtract(ph)
}
\arguments{
\item{ph}{A testMultipleControl test object}
}
\value{
an experiment object
}
\description{
This functions generates a new experiment incluing the methods that obtained
an equivalent performance with statisticall significance in the multiple
comparison test i.e. those whose hypotheses were not rejected
}
\examples{
# First we create an experiment from the wekaExperiment problem and prepare
# it to apply the test:
experiment <- expCreate(wekaExperiment, name="test", parameter="fold")
experiment <- expReduce(experiment, "fold", mean)
experiment <- expInstantiate(experiment, removeUnary=TRUE)

# Then we perform a testMultiplePairwise test procedure
test <- testMultipleControl(experiment, "trainingTime", "min")

expExtract(test)
}

