% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2-mod.R
\name{modFilter}
\alias{modFilter}
\title{Hard Filter Data}
\usage{
modFilter(object, threshold, maximum, beta1, beta2)
}
\arguments{
\item{object}{An \code{ExprsArray} object to undergo pre-processing.}

\item{threshold}{A numeric scalar. The value below which to assign this value.}

\item{maximum}{A numeric scalar. The value above which to assign this value.}

\item{beta1}{A numeric scalar. The \code{max - min} range above which to
include the feature. Inclusive with \code{beta2}.}

\item{beta2}{A numeric scalar. The \code{max / min} ratio above which to
include the feature. Inclusive with \code{beta1}.}
}
\value{
A pre-processed \code{ExprsArray} object.
}
\description{
\code{modFilter} imposes a hard filter for (gene expression) feature data.
}
\details{
This method reproduces the hard filter described by Deb and Reddy (2003)
 for pre-processing the hallmark Golub ALL/AML dataset. This filter
 first sets all values less than \code{threshold} to \code{threshold}
 and all values greater than \code{maximum} to \code{maximum}.

Next, this method includes only those features with (a) a range greater
 than \code{beta1}, and also (b) a ratio of maximum feature expression to
 minimum feature expression greater than \code{beta2}.
}
