% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5.2-build.R
\docType{methods}
\name{build}
\alias{build}
\alias{buildANN}
\alias{buildANN,ExprsArray-method}
\alias{buildDNN}
\alias{buildDNN,ExprsArray-method}
\alias{buildLDA}
\alias{buildLDA,ExprsArray-method}
\alias{buildNB}
\alias{buildNB,ExprsArray-method}
\alias{buildRF}
\alias{buildRF,ExprsArray-method}
\alias{buildSVM}
\alias{buildSVM,ExprsArray-method}
\title{Build Classifiers}
\usage{
buildNB(object, top = 0, ...)

buildLDA(object, top = 0, ...)

buildSVM(object, top = 0, ...)

buildANN(object, top = 0, ...)

buildRF(object, top = 0, ...)

buildDNN(object, top = 0, ...)

\S4method{buildNB}{ExprsArray}(object, top = 0, ...)

\S4method{buildLDA}{ExprsArray}(object, top = 0, ...)

\S4method{buildSVM}{ExprsArray}(object, top = 0, ...)

\S4method{buildANN}{ExprsArray}(object, top = 0, ...)

\S4method{buildRF}{ExprsArray}(object, top = 0, ...)

\S4method{buildDNN}{ExprsArray}(object, top = 0, ...)
}
\arguments{
\item{object}{Specifies the \code{ExprsArray} object to use as a training set
for classification.}

\item{top}{A numeric scalar or character vector. A numeric scalar indicates
the number of top features that should undergo feature selection. A character vector
indicates specifically which features by name should undergo feature selection.
Set \code{top = 0} to include all features. A numeric vector can also be used
to indicate specific features by location, similar to a character vector.}

\item{...}{Arguments passed to the respective wrapped function.}
}
\value{
Returns an \code{ExprsModel} object.
}
\description{
A collection of functions to build classifiers.
}
\details{
These \code{build} methods construct a single classifier given an \code{ExprsArray}
 object and a set of parameters. This function returns an \code{ExprsModel} object.
 In the case of binary classification, these methods use an \code{ExprsBinary}
 object and return an \code{ExprsMachine} object. In the case of multi-class
 classification, these methods use an \code{ExprsMulti} object and return an
 \code{ExprsModule} object. In the case of multi-class classification, these methods
 harness the \code{\link{doMulti}} function to perform "1 vs. all" classifier
 construction. In the setting of four class labels, a single \code{build} call
 will return four classifiers that work in concert to make a single prediction
 of an unlabelled subject. For building multiple classifiers across a vast
 parameter space in a high-throughput manner, see \code{pl} methods.

Like \code{\link{fs}} methods, \code{build} methods have a \code{top} argument
 which allows the user to specify which features to feed INTO the classifier
 build. This effectively provides the user with one last opportunity to subset
 the feature space based on prior feature selection or dimension reduction.
 For all build methods, \code{@preFilter} and \code{@reductionModel} will
 get passed along to the resultant \code{ExprsModel} object, again ensuring
 that any test or validation sets will undergo the same feature selection and
 dimension reduction in the appropriate steps when deploying the classifier.
 Set \code{top = 0} to pass all features through a \code{build} method.

See \code{\link{modHistory}} to learn more about feature selection history.
}
\section{Methods (by generic)}{

\code{buildNB:} Method to build classifiers using e1071::naiveBayes.


\code{buildLDA:} Method to build classifiers using MASS::lda.


\code{buildSVM:} Method to build classifiers using e1071::svm.


\code{buildANN:} Method to build classifiers using nnet::nnet.


\code{buildRF:} Method to build classifiers using randomForest::randomForest.


\code{buildDNN:} Method to build feed-forward networks using h2o::h2o.deeplearning.
}
\examples{
\dontrun{
library(golubEsets)
data(Golub_Merge)
array <- arrayEset(Golub_Merge, colBy = "ALL.AML", include = list("ALL", "AML"))
array <- modFilter(array, 20, 16000, 500, 5) # pre-filter Golub ala Deb 2003
array <- modTransform(array) # lg transform
array <- modNormalize(array, c(1, 2)) # normalize gene and subject vectors
arrays <- splitSample(array, percent.include = 67)
array.train <- fsStats(arrays[[1]], top = 0, how = "t.test")
array.train <- fsPrcomp(array.train, top = 50)
mach <- buildSVM(array.train, top = 5, kernel = "linear", cost = 1)
}
}
\seealso{
\code{\link{fs}}\cr
\code{\link{build}}\cr
\code{\link{doMulti}}\cr
\code{\link{exprso-predict}}\cr
\code{\link{plCV}}\cr
\code{\link{plGrid}}\cr
\code{\link{plGridMulti}}\cr
\code{\link{plMonteCarlo}}\cr
\code{\link{plNested}}
}

