#' @name POWOcodes
#'
#' @docType data
#'
#' @title Complete list of angiosperm families and associated URI addresses
#'
#' @description Complete list of the APG IV-based families of flowering plants
#' and associated URI addresses as retrieved with the function get_pow of the
#' package [taxize](https://docs.ropensci.org/taxize/index.html).
#'
#' @format Dataframe
#'
#' @usage data(POWOcodes)

NULL

#' @name botregions
#'
#' @docType data
#'
#' @title Countries and associated classification of botanical divisions
#'
#' @description Countries and associated classification of botanical divisions
#' according to the World Geographical Scheme for Recording Plant Distributions.
#'
#' @format Table in .csv format
#'
#' @source <https://www.tdwg.org/standards/wgsrpd/>
#'
#' @usage data(botregions)

NULL

#' @name angioData
#'
#' @docType data
#'
#' @title List of Angiosperm species
#'
#' @description Complete list of all non-hybrid species and
#' associated data of Lecythidaceae, Aristolochiaceae, Martyniaceae,
#' Cabombaceae and Begoniaceae as retrieved from POWO database with the function
#' \code{powoSpecies} of this package gathered at Nov 2022.
#'
#' @format Dataframe
#'
#' @usage data(angioData)

NULL

#' @name angioGenera
#'
#' @docType data
#'
#' @title List of Angiosperm genera
#'
#' @description Complete list of all genera and associated data of
#' Lecythidaceae, Aristolochiaceae, Begoniaceae, Martyniaceae, Dipterocarpaceae,
#' and Fagaceae as retrieved from POWO database with the function
#' \code{powoGenera} of this package gathered at Jan 2023.
#'
#' @format Dataframe
#'
#' @usage data(angioGenera)

NULL
