/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public class ExPANdS {
    public static final int DEFAULT_MAX_PM = 6;
    private static int min_PM = 1;
    private static int PN = 2;
    private List<FitAlternatives> solutions;
    private double CN;
    private double AF;
    private double CN_Error = 0.1;
    private int PN_B;
    private double minErr;
    private double[] alternativeCN;
    private FitAlternatives bestSolution;
    private int max_PM;
    public static final String[] SOLUTION_ENTITIES = new String[]{"PN", "PN_B", "PM", "PM_B", "CN_Estimate", "AF_Tumor", "f", "dev"};

    public double getDeviation() {
        return this.minErr;
    }

    public ExPANdS(double af, double cn, int pnb, int max_PM) {
        this.max_PM = max_PM;
        this.bestSolution = new FitAlternatives(1, -1, -1);
        this.bestSolution.add(0, Double.NaN, Double.NaN);
        this.AF = af;
        this.CN = cn;
        this.PN_B = pnb;
        double step = 0.005;
        int alt = (int)Math.floor((this.CN + this.CN_Error - Math.max(0.0, this.CN - this.CN_Error)) / step);
        this.alternativeCN = new double[alt];
        this.alternativeCN[0] = Math.max(0.0, this.CN - this.CN_Error);
        int i = 1;
        while (i < this.alternativeCN.length) {
            this.alternativeCN[i] = this.alternativeCN[i - 1] + step;
            ++i;
        }
    }

    public void run() {
        this.minErr = Double.POSITIVE_INFINITY;
        int nIter = this.max_PM - min_PM + 1;
        int[][] PM = new int[nIter][nIter];
        int[][] PM_B = new int[nIter][nIter];
        this.solutions = new ArrayList<FitAlternatives>(PM.length * PM_B.length);
        int pm = min_PM;
        while (pm <= this.max_PM) {
            double copyPenality = Math.pow(Math.abs((long)pm - Math.round(this.CN)) + 1L, 3.0);
            int pmb = min_PM;
            while (pmb <= pm) {
                if (!((double)pmb / (double)pm <= (double)this.PN_B / (double)PN)) {
                    Array2DRowRealMatrix coefficients = new Array2DRowRealMatrix(new double[][]{{pm - PN}, {pmb - this.PN_B}}, false);
                    int i = pm - min_PM;
                    int j = pmb - min_PM;
                    PM[i][j] = pm;
                    PM_B[i][j] = pmb;
                    FitAlternatives alternatives = new FitAlternatives(this.alternativeCN.length, pm, pmb);
                    int k = 0;
                    while (k < this.alternativeCN.length) {
                        double cn = this.alternativeCN[k];
                        ArrayRealVector constants = new ArrayRealVector(new double[]{cn - (double)PN, cn * this.AF - (double)this.PN_B}, false);
                        DecompositionSolver solver = new SingularValueDecomposition(coefficients).getSolver();
                        RealVector solution = solver.solve(constants);
                        RealVector errorterm = coefficients.operate(solution).subtract(constants);
                        double sumErr = copyPenality * (Math.abs(errorterm.getEntry(0)) + Math.abs(errorterm.getEntry(1)) + Math.abs(this.CN - cn));
                        alternatives.add(k, solution.getEntry(0), sumErr);
                        if (solution.getEntry(0) > -0.1 && solution.getEntry(0) <= 1.1 && this.minErr > sumErr) {
                            this.minErr = sumErr;
                            this.bestSolution = alternatives;
                        }
                        ++k;
                    }
                    this.solutions.add(alternatives);
                }
                ++pmb;
            }
            ++pm;
        }
    }

    public int getPM_B() {
        return this.bestSolution.getPM_B();
    }

    public int getPM() {
        return this.bestSolution.getPM();
    }

    public double getF() {
        try {
            return this.bestSolution.getBest().getF();
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public void printFitsToFile(File f) throws IOException {
        BufferedWriter w = Common.getWriter(f.getAbsolutePath());
        w.write(Common.toString(SOLUTION_ENTITIES, "\t"));
        w.newLine();
        for (FitAlternatives fits : this.solutions) {
            Iterator<Solution> iter = fits.iterator();
            while (iter.hasNext()) {
                w.write(iter.next().toString());
                w.newLine();
            }
        }
        w.flush();
        w.close();
    }

    public Collection<FitAlternatives> solutions() {
        return this.solutions;
    }

    public static void main(String[] args) {
        Object[] files = new File(System.getProperty("user.dir")).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(".snv");
            }
        });
        Arrays.sort(files);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object f = objectArray[n2];
            System.out.println(((File)f).getName());
            File pair = new File(String.valueOf(((File)f).getAbsolutePath()) + ".expands");
            if (pair.exists()) {
                System.out.println("ExPANdS file for " + ((File)f).getName() + " already exists. Skipped.");
            } else {
                int count = 0;
                try {
                    BufferedReader r = Common.getReader(((File)f).getAbsolutePath());
                    BufferedWriter w = Common.getWriter(pair.getAbsolutePath());
                    Object[] header = r.readLine().trim().split("\\s+");
                    w.write(Common.toString((String[])header, "\t"));
                    w.newLine();
                    int countI = Common.firstIndexOf("Count", header);
                    int afI = Common.firstIndexOf("AF_Tumor", header);
                    int cnI = Common.firstIndexOf("CN_Estimate", header);
                    int pnbI = Common.firstIndexOf("PN_B", header);
                    int pABBBI = Common.firstIndexOf("pABBB", header);
                    int pAABBI = Common.firstIndexOf("pAABB", header);
                    int pAAABI = Common.firstIndexOf("pAAAB", header);
                    int fI = Common.firstIndexOf("f", header);
                    int pmI = Common.firstIndexOf("PM", header);
                    int pmbI = Common.firstIndexOf("PM_B", header);
                    int devI = Common.firstIndexOf("dev", header);
                    String l = r.readLine();
                    while (l != null) {
                        String[] features = l.trim().split("\t");
                        if (features.length > header.length) {
                            features = Arrays.copyOfRange(features, 1, features.length);
                        }
                        int id = (int)Double.parseDouble(features[countI]);
                        int pnb = (int)Math.round(Double.parseDouble(features[pABBBI]));
                        try {
                            ExPANdS expands = new ExPANdS(Double.parseDouble(features[afI]), Double.parseDouble(features[cnI]), pnb, 6);
                            expands.run();
                            double pAABB = Double.parseDouble(features[pAABBI]);
                            double pABBB = Double.parseDouble(features[pABBBI]);
                            double pAAAB = Double.parseDouble(features[pAAABI]);
                            if (pABBB >= 0.5 || pAABB + pAAAB >= 0.9) {
                                expands.printFitsToFile(new File(String.valueOf(((File)f).getAbsolutePath()) + "." + id + ".fit"));
                                ++count;
                            }
                            features[pmI] = "" + expands.getPM();
                            features[pmbI] = "" + expands.getPM_B();
                            features[fI] = "" + expands.getF();
                            features[devI] = "" + expands.getDeviation();
                            features[pnbI] = "" + pnb;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        w.write(Common.toString(features, "\t").replace("Infinity", "Inf"));
                        w.newLine();
                        l = r.readLine();
                    }
                    w.flush();
                    w.close();
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public class FitAlternatives
    implements Iterator<Solution>,
    Iterable<Solution> {
        private double[] f;
        private double[] dev;
        private int pm;
        private int pmb;
        int idx = -2;

        private FitAlternatives(int numerAlternatives, int pm, int pmb) {
            this.f = new double[numerAlternatives];
            this.dev = new double[numerAlternatives];
            this.pm = pm;
            this.pmb = pmb;
        }

        public int getPM_B() {
            return this.pmb;
        }

        public int getPM() {
            return this.pm;
        }

        @Override
        public Iterator<Solution> iterator() {
            this.idx = -1;
            return this;
        }

        public double getF(int k) {
            return this.f[k];
        }

        public double getDev(int k) {
            return this.dev[k];
        }

        public int size() {
            return this.dev.length;
        }

        public Solution getBest() {
            int bestIdx = Common.argmin(this.dev);
            return new Solution(PN, ExPANdS.this.PN_B, this.pm, this.pmb, ExPANdS.this.CN, ExPANdS.this.AF, this.f[bestIdx], this.dev[bestIdx]);
        }

        public void add(int idx, double f, double dev) {
            this.f[idx] = f;
            this.dev[idx] = dev;
        }

        @Override
        public boolean hasNext() {
            return this.idx > -2 && this.idx < this.f.length - 1;
        }

        @Override
        public Solution next() {
            ++this.idx;
            if (this.idx >= this.dev.length) {
                return null;
            }
            return new Solution(PN, ExPANdS.this.PN_B, this.pm, this.pmb, ExPANdS.this.CN, ExPANdS.this.AF, this.f[this.idx], this.dev[this.idx]);
        }

        @Override
        public void remove() {
        }
    }

    public final class Solution {
        private double f;
        private double AF;
        private double CN;
        private int PM_B;
        private int PM;
        private int PN_B;
        private int PN;
        private double dev;

        public Solution(int PN, int PN_B, int PM, int PM_B, double CN, double AF, double f, double dev) {
            this.PN = PN;
            this.PN_B = PN_B;
            this.PM = PM;
            this.PM_B = PM_B;
            this.CN = CN;
            this.AF = AF;
            this.f = f;
            this.dev = dev;
        }

        public double getF() {
            return this.f;
        }

        public double[] toDouble() {
            return new double[]{this.PN, this.PN_B, this.PM, this.PM_B, this.CN, this.AF, this.f, this.dev};
        }

        public String toString() {
            return Common.toString(this.toDouble(), "\t");
        }
    }
}

