% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iwls.R
\name{iwls}
\alias{iwls}
\title{Iterated weighted least squares estimation of the extremal index}
\usage{
iwls(data, u, maxit = 100)
}
\arguments{
\item{data}{A numeric vector of raw data.  No missing values are allowed.}

\item{u}{A numeric scalar.  Extreme value threshold applied to data.}

\item{maxit}{A numeric scalar.  The maximum number of iterations.}
}
\value{
An object (a list) of class \code{"iwls", "exdex"} containing
    \item{\code{theta} }{The estimate of \eqn{\theta}.}
    \item{\code{conv} }{A convergence indicator: 0 indicates successful
      convergence; 1 indicates that \code{maxit} has been reached.}
    \item{\code{niter} }{The number of iterations performed.}
    \item{\code{n_gaps }}{The number of time gaps between successive
      exceedances.}
    \item{\code{call }}{The call to \code{iwls}.}
}
\description{
Estimates the extremal index \eqn{\theta} using the iterated weighted least
squares method of Suveges (2007).  At the moment no estimates of
uncertainty are provided.
}
\details{
The iterated weighted least squares algorithm on page 46 of
  Suveges (2007) is used to estimate the value of the extremal index.
  This approach uses the time \emph{gaps} between successive exceedances
  in the data \code{data} of the threshold \code{u}.  The \eqn{i}th
  gap is defined as \eqn{T_i - 1}, where \eqn{T_i} is the difference in
  the occurrence time of exceedance \eqn{i} and exceedance \eqn{i + 1}.
  Therefore, threshold exceedances at adjacent time points produce a gap
  of zero.

  The model underlying this approach is an exponential-point mas mixture
  for \emph{scaled gaps}, that is, gaps multiplied by the proportion of
  values in  \code{data} that exceed \code{u}.  Under this model
  scaled gaps are zero (`within-cluster' interexceedance times) with
  probability \eqn{1 - \theta} and otherwise (`between-cluster'
  interexceedance times) follow an exponential distribution with mean
  \eqn{1 / \theta}.
  The estimation method is based on fitting the `broken stick' model of
  Ferro (2003) to an exponential quantile-quantile plot of all of the
  scaled gaps.  Specifically, the broken stick is a horizontal line
  and a line with gradient \eqn{1 / \theta} which intersect at
  \eqn{(-\log\theta, 0)}{(-log \theta, 0)}.  The algorithm on page 46 of
  Suveges (2007) uses a weighted least squares minimization applied to
  the exponential
  part of this model to seek a compromise between the role of \eqn{\theta}
  as the proportion of interexceedance times that are between-cluster
  and the reciprocal of the mean of an exponential distribution for these
  interexceedance times.  The weights (see Ferro (2003)) are based on the
  variances of order statistics of a standard exponential sample: larger
  order statistics have larger sampling variabilities and therefore
  receive smaller weight than smaller order statistics.

  Note that in step (1) of the algorithm on page 46 of Suveges there is a
  typo: \eqn{N_c + 1} should be \eqn{N}, where \eqn{N} is the number of
  threshold exceedances.  Also, the gaps are scaled as detailed above,
  not by their mean.
}
\examples{
### S&P 500 index

u <- quantile(sp500, probs = 0.60)
theta <- iwls(sp500, u)
theta

### Newlyn sea surges

u <- quantile(newlyn, probs = 0.90)
theta <- iwls(newlyn, u)
theta
}
\references{
Suveges, M. (2007) Likelihood estimation of the extremal
  index. \emph{Extremes}, \strong{10}, 41-55.
  \url{https://doi.org/10.1007/s10687-007-0034-2}

Ferro, C.A.T. (2003) Statistical methods for clusters of
  extreme values. Ph.D. thesis, Lancaster University.
}
\seealso{
\code{\link{kgaps}} for maximum likelihood estimation of the
  extremal index \eqn{\theta} using the \eqn{K}-gaps model.

\code{\link{spm}} for estimation of the extremal index
  \eqn{\theta} using a semiparametric maxima method.
}
