% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location.R
\name{exclude_location}
\alias{exclude_location}
\title{Exclude locations outside of US}
\usage{
exclude_location(
  x,
  id_col = "ResponseId",
  location_col = c("LocationLatitude", "LocationLongitude"),
  include_na = FALSE,
  quiet = TRUE,
  print = TRUE,
  silent = FALSE
)
}
\arguments{
\item{x}{Data frame (preferably imported from Qualtrics using \{qualtRics\}).}

\item{id_col}{Column name for unique row ID (e.g., participant).}

\item{location_col}{Two element vector specifying columns for latitude
and longitude (in that order).}

\item{include_na}{Logical indicating whether to include rows with NA in
latitude and longitude columns in the output list of potentially excluded
data.}

\item{quiet}{Logical indicating whether to print message to console.}

\item{print}{Logical indicating whether to print returned tibble to
console.}

\item{silent}{Logical indicating whether to print message to console. Note
this argument controls the exclude message not the check message.}
}
\value{
An object of the same type as \code{x} that excludes rows
that are located outside of the US and (if \code{include_na == FALSE}) rows with
no location information.
For a function that checks for these rows, use \code{\link[=check_location]{check_location()}}.
For a function that marks these rows, use \code{\link[=mark_location]{mark_location()}}.
}
\description{
The \code{exclude_location()} function removes
rows that have locations outside of the US.
The function is written to work with data from
\href{https://www.qualtrics.com/}{Qualtrics} surveys.
}
\details{
Default column names are set based on output from the
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.
The function only works for the United States.
It uses the #' \code{\link[maps:map.where]{maps::map.where()}} to determine if latitude and longitude
are inside the US.

The function outputs to console a message about the number of rows
with locations outside of the US.
}
\examples{
# Exclude locations outside of the US
data(qualtrics_text)
df <- exclude_location(qualtrics_text)

# Remove preview data first
df <- qualtrics_text \%>\%
  exclude_preview() \%>\%
  exclude_location()
}
\seealso{
Other location functions: 
\code{\link{check_location}()},
\code{\link{mark_location}()}

Other exclude functions: 
\code{\link{exclude_duplicates}()},
\code{\link{exclude_duration}()},
\code{\link{exclude_ip}()},
\code{\link{exclude_preview}()},
\code{\link{exclude_progress}()},
\code{\link{exclude_resolution}()}
}
\concept{exclude functions}
\concept{location functions}
