% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xl.write.R
\name{xl.write}
\alias{xl.write}
\alias{xl.write.current.graphics}
\alias{xl.write.list}
\alias{xl.write.matrix}
\alias{xl.write.data.frame}
\alias{xl.write.default}
\title{Methods for writing data to Excel sheet}
\usage{
xl.write(r.obj, xl.rng, na = "", ...)

\method{xl.write}{current.graphics}(r.obj, xl.rng, na = "",
  delete.file = FALSE, ...)

\method{xl.write}{list}(r.obj, xl.rng, na = "", ...)

\method{xl.write}{matrix}(r.obj, xl.rng, na = "", row.names = TRUE,
  col.names = TRUE, ...)

\method{xl.write}{data.frame}(r.obj, xl.rng, na = "", row.names = TRUE,
  col.names = TRUE, ...)

\method{xl.write}{default}(r.obj, xl.rng, na = "", row.names = TRUE, ...)
}
\arguments{
\item{r.obj}{R object}

\item{xl.rng}{An object of class \code{COMIDispatch} (as used in RDCOMClient 
package) - reference to Excel range}

\item{na}{character. NA representation in Excel. By default it is empty string}

\item{...}{arguments for further processing}

\item{delete.file}{a logical value indicating whether delete file with 
graphics after insertion in Excel}

\item{row.names}{a logical value indicating whether the row names/vector 
names of r.obj should to be written along with r.obj}

\item{col.names}{a logical value indicating whether the column names of r.obj
should to be written along with r.obj}
}
\value{
c(rows,columns) Invisibly returns rows and columns number ocuppied by
\code{r.obj} on Excel sheet.
}
\description{
Methods for writing data to Excel sheet
}
\details{
\code{xl.rng} should be COM-reference to Excel range, not string. Method 
invisibly returns number of columns and rows occupied by \code{r.obj} on
Excel sheet. It's useful for multiple objects writing to prevent their
overlapping. It is more convenient to use \code{xl} object. \code{xl.write}
aimed mostly for programming purposes, not for interactive usage.
}
\examples{
\dontrun{
xls = xl.get.excel()
xl.workbook.add()
rng = xls[["Activesheet"]]$Cells(1,1)
nxt = xl.write(iris,rng,row.names = TRUE,col.names = TRUE)
rng = rng$Offset(nxt[1] + 1,0)
nxt = xl.write(cars,rng,row.names = TRUE,col.names = TRUE)
rng = rng$Offset(nxt[1] + 1,0)
nxt = xl.write(as.data.frame(Titanic),rng,row.names = TRUE,col.names = TRUE)

data(iris)
data(cars)
data(Titanic)
xl.sheet.add()
rng = xls[["Activesheet"]]$Cells(1,1)
data.sets = list("Iris dataset",iris,
     "Cars dataset",cars,
     "Titanic dataset",as.data.frame(Titanic))
xl.write(data.sets,rng,row.names = TRUE,col.names = TRUE)

}
}
\seealso{
\code{\link{xl}},
\code{\link{xlr}}, \code{\link{xlc}}, \code{\link{xlrc}}, 
\code{\link{current.graphics}}
}
