% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exact_extract.R
\docType{methods}
\name{exact_extract}
\alias{exact_extract}
\alias{exact_extract,Raster,sf-method}
\alias{exact_extract,Raster,sfc_MULTIPOLYGON-method}
\alias{exact_extract,Raster,sfc_POLYGON-method}
\title{Extract or summarize values from Raster* objects}
\usage{
\S4method{exact_extract}{Raster,sf}(x, y, fun = NULL, ...,
  include_xy = FALSE, progress = TRUE, max_cells_in_memory = 3e+07)

\S4method{exact_extract}{Raster,sfc_MULTIPOLYGON}(x, y, fun = NULL, ...,
  include_xy = FALSE, progress = TRUE, max_cells_in_memory = 3e+07)

\S4method{exact_extract}{Raster,sfc_POLYGON}(x, y, fun = NULL, ...,
  include_xy = FALSE, progress = TRUE, max_cells_in_memory = 3e+07)
}
\arguments{
\item{x}{a RasterLayer}

\item{y}{a sf object with polygonal geometries}

\item{fun}{an optional function or character vector, as described below}

\item{...}{additional arguments to pass to \code{fun}}

\item{include_xy}{if \code{TRUE}, augment the returned data frame with
columns for cell center coordinates (\code{x} and
\code{y}) or pass them to \code{fun}}

\item{progress}{if \code{TRUE}, display a progress bar during processing}

\item{max_cells_in_memory}{the maximum number of raster cells to load at
a given time when using a named summary operation
for \code{fun} (as opposed to a function defined using
R code). If a polygon covers more than \code{max_cells_in_memory}
raster cells, it will be processed in multiple chunks.}
}
\value{
a vector or list of data frames, depending on the value of \code{fun}
        (see Details)
}
\description{
Extracts the values of cells in a RasterLayer that are covered by a
simple feature collection containing polygonal geometries, as well as the
fraction of each cell that is covered by the polygon. Returns either
the result of a summary operation or function applied to the values
and coverage fractions (if \code{fun} is specified), or a data frame
containing the values and coverage fractions themselves (if \code{fun}
is \code{NULL}.)
}
\details{
The value of \code{fun} may be set to a string (or vector of strings)
representing summary operations supported by the exactextract library.
If a single summary operation is specified, \code{exact_extract} will
return a vector with the result of the summary operation for each
feature in the input. If multiple summary operations are specified,
\code{exact_extract} will return a data frame with the result of each
summary operation for each feature.

The following summary operations are supported:

\itemize{
 \item{\code{min} - the minimum defined value in any raster cell wholly or
                    partially covered by the polygon}
 \item{\code{max} - the maximum defined value in any raster cell wholly or
                    partially covered by the polygon}
 \item{\code{count} - the sum of fractions of raster cells with defined values
                      covered by the polygon}
 \item{\code{sum}   - the sum of defined raster cell values, multiplied by
                      the fraction of the cell that is covered by the polygon}
 \item{\code{mean} - the mean cell value, weighted by the fraction of each cell
                     that is covered by the polygon}
 \item{\code{mode} - the most common cell value, weighted by the fraction of
                     each cell that is covered by the polygon. Where multiple
                     values occupy the same maximum number of weighted cells,
                     the largest value will be returned.}
 \item{\code{majority} - synonym for \code{mode}}
 \item{\code{minority} - the least common cell value, weighted by the fraction
                         of each cell that is covered by the polygon. Where
                         multiple values occupy the same minimum number of
                         weighted cells, the smallest value will be returned.}
 \item{\code{variety} - the number of distinct values in cells that are wholly
                        or partially covered by the polygon.}
}

Alternatively, an R function may be provided as \code{fun}. The function will be
called for each feature with with vectors of cell values and weights as arguments.
\code{exact_extract} will then return a vector of the return values of \code{fun}.

If \code{fun} is not specified, \code{exact_extract} will return a list with
one data frame for each feature in the input feature collection. The data
frame will contain a column with values from each layer in the input `Raster*`,
and a final column indicating the fraction of the cell that is covered by the
polygon.
}
\examples{
rast <- raster::raster(matrix(1:100, ncol=10), xmn=0, ymn=0, xmx=10, ymx=10)
poly <- sf::st_as_sfc('POLYGON ((2 2, 7 6, 4 9, 2 2))')

exact_extract(rast, poly, 'mean')

# two summary operations, returns data frame
exact_extract(rast, poly, c('min', 'max'))

# custom summary function, returns vector
exact_extract(rast, poly, function(value, cov_frac) length(value[cov_frac > 0.9]))

}
