% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fns.R
\name{variance_complete}
\alias{variance_complete}
\title{A function for variance assuming a complete sample}
\usage{
variance_complete(x)
}
\arguments{
\item{x}{A numeric vector that represents a complete sample.}
}
\value{
The variance of the entries of x, calculated with the assumption that
x represents a complete sample. Compare to the output of
\code{\link[stats]{var}}.
}
\description{
The variance, assuming a complete sample, is the mean of the squared
deviations. When you assume an incomplete sample (the standard assumption in
statistics), the variance is calculated as the sum of squared deviations,
divided by (N-1), where N is the number of observations in the sample. As
such, the output of \code{variance_complete} will always be smaller than the
output of \code{var}.
}
\examples{
test<- c(5, 6, 8, 10, 25)
Vc<- variance_complete(test)
# compare this output with that of var()
}
\seealso{
\code{\link[stats]{var}}
}
