% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fns.R
\name{cov_matrix}
\alias{cov_matrix}
\title{The variance-covariance matrix for a set of population projection matrices}
\usage{
cov_matrix(Aobj)
}
\arguments{
\item{Aobj}{A matrix where each row is the column-wise vectorization of a
population projection matrix.}
}
\value{
The variance-covariance matrix for the vital rates of the population
projection matrices. If the dimensions of each matrix in \code{Aobj} are n-by-n,
then the variance-covariance matrix will have dimensions n^2-by-n^2.
}
\description{
Calculate the variance-covariance matrix for the vital rates of a series of
population projection matrices.
}
\details{
The diagonal entries of the variance-covariance matrix give the
variance of the entries in each index of the matrix. The off-diagonal entries
of the variance-covariance matrix give the covariance of entries in each index
of the matrix. The variance-covariance matrix is symmetrical, and the
covariance of a given pair of vital rates is the sum of the two corresponding
indices.
}
\examples{
A1<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
A2<- matrix(data=c(0,0.9,0, 0,0,0.5, 4,0,0.3), nrow=3, ncol=3)
A3<- matrix(data=c(0,0.4,0, 0,0,0.6, 6,0,0.25), nrow=3, ncol=3)
A_all<- collapse_mat_list(list(A1, A2, A3))
covmat<- cov_matrix(A_all)
}
