% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcAVG.R
\name{CalcAVG}
\alias{CalcAVG}
\title{Calculates mean correlations within- and between-modules}
\usage{
CalcAVG(cor.hypothesis, cor.matrix, MHI = TRUE, landmark.dim = NULL)
}
\arguments{
\item{cor.hypothesis}{Hypothetical correlation matrix, with 1s within-modules and 0s between modules}

\item{cor.matrix}{Observed empirical correlation matrix.}

\item{MHI}{Indicates if Modularity Hypothesis Index should be calculated instead of AVG Ratio.}

\item{landmark.dim}{Used if within-landmark correlations are to be excluded in geometric morphometric data. Either 2 for 2d data or 3 for 3d data. Default is NULL for non geometric morphomotric data.}
}
\value{
a named vector with the mean correlations and derived statistics
}
\description{
Uses a binary correlation matrix as a mask to calculate average within- and between-module
correlations. Also calculates the ratio between them and the Modularity Hypothesis Index.
}
\examples{
# Module vectors
modules = matrix(c(rep(c(1, 0, 0), each = 5),
                   rep(c(0, 1, 0), each = 5),
                   rep(c(0, 0, 1), each = 5)), 15)

# Binary modular matrix
cor.hypot = CreateHypotMatrix(modules)[[4]]

# Modular correlation matrix
hypot.mask = matrix(as.logical(cor.hypot), 15, 15)
mod.cor = matrix(NA, 15, 15)
mod.cor[ hypot.mask] = runif(length(mod.cor[ hypot.mask]), 0.8, 0.9) # within-modules
mod.cor[!hypot.mask] = runif(length(mod.cor[!hypot.mask]), 0.3, 0.4) # between-modules
diag(mod.cor) = 1
mod.cor = (mod.cor + t(mod.cor))/2 # correlation matrices should be symmetric

CalcAVG(cor.hypot, mod.cor)
CalcAVG(cor.hypot, mod.cor, MHI = TRUE)
}
