% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MatrixDistance.R
\name{MatrixDistance}
\alias{MatrixDistance}
\alias{MatrixDistance.default}
\alias{MatrixDistance.list}
\title{Matrix distance}
\usage{
MatrixDistance(cov.x, cov.y, distance, ...)

\method{MatrixDistance}{default}(cov.x, cov.y, distance = c("OverlapDist", "RiemannDist"), ...)

\method{MatrixDistance}{list}(
  cov.x,
  cov.y = NULL,
  distance = c("OverlapDist", "RiemannDist"),
  ...,
  parallel = FALSE
)
}
\arguments{
\item{cov.x}{Single covariance matrix or list of covariance matrices.
If single matrix is suplied, it is compared to cov.y.
If list is suplied and no cov.y is suplied, all matrices
are compared.
If cov.y is suplied, all matrices in list are compared to it.}

\item{cov.y}{First argument is compared to cov.y.
Optional if cov.x is a list.}

\item{distance}{distance function for use in calculation. Currently supports "Riemann" and "Overlap".}

\item{...}{aditional arguments passed to other methods}

\item{parallel}{if TRUE and a list is passed, computations are done in parallel. Some foreach backend must be registered, like doParallel or doMC.}
}
\value{
If cov.x and cov.y are passed, returns distance between them.

If is a list cov.x and cov.y are passed, same as above, but for all matrices in cov.x.

If only a list is passed to cov.x, a matrix of Distances is returned
}
\description{
Calculates Distances between covariance matrices.
}
\examples{
c1 <- RandomMatrix(10)
c2 <- RandomMatrix(10)
c3 <- RandomMatrix(10)
MatrixDistance(c1, c2, "OverlapDist")
MatrixDistance(c1, c2, "RiemannDist")
\dontrun{
MatrixDistance(list(c1, c2, c3), distance = "OverlapDist")


c4 <- RandomMatrix(10)
MatrixDistance(list(c1, c2, c3), c4)
}
}
\seealso{
\code{\link{RiemannDist}},\code{\link{OverlapDist}}
}
\author{
Diogo Melo
}
\keyword{matrixDistance}
\keyword{matrixcomparison}
