% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_functions_3d.R
\name{get_features_3d}
\alias{get_features_3d}
\title{Computes event-features}
\usage{
get_features_3d(dat.xyz, res.cluster, normal.stats, win_size, tt)
}
\arguments{
\item{dat.xyz}{The data in a cluster friendly format. The first three columns have \code{t},\code{x} and \code{y} positions with the fourth column having the pixel value of that position.}

\item{res.cluster}{Cluster details from \code{dbscan}.}

\item{normal.stats}{The background statistics, output from \code{\link{stats_3d}}.}

\item{win_size}{The window length of the moving window model.}

\item{tt}{Related to event ages. For example if \code{tt=10} then the event ages are \code{10, 20, 30} and \code{40}.}
}
\value{
An \code{Nx22x4} array  is returned. Here \code{N} is the total number of  events extracted in all windows. The second dimension has \code{30} features and the class label for the \code{supervised} setting.  The third dimension has \code{4} different event ages : \code{tt, 2tt, 3tt, 4tt}.
For example, the element at \code{[10,6,3]} has the 6th feature,   of the 10th extracted event when the age of the event is \code{3tt}. The features are listed below:
  \item{\code{cluster_id}}{An identification number for each event.}
  \item{\code{pixels}}{The number of pixels of each event.}
  \item{\code{length}}{The length of the event.}
  \item{\code{width}}{The width of the event.}
  \item{\code{total_value}}{The total value of the pixels.}
  \item{\code{l2w_ratio}}{Length to width ratio of event.}
  \item{\code{centroid_x}}{x coordinate of event centroid.}
  \item{\code{centroid_y}}{y coordinate of event centroid.}
  \item{\code{centroid_z}}{z coordinate of event centroid.}
  \item{\code{mean}}{Mean value of event pixels.}
  \item{\code{std_dev}}{Standard deviation of event pixels.}
  \item{\code{slope}}{Slope of a linear model fitted to the event.}
  \item{\code{quad1}}{First coefficient of a quadratic model fitted to the event.}
  \item{\code{quad2}}{Second coefficient of a quadratic model fitted to the event.}
  \item{\code{sd_from_mean}}{Let us denote the 80th percentile of the event pixels value by \code{x}. How many  standard deviations is \code{x} is away from the mean? }
}
\description{
This function computes event features of 3D events.
}
\examples{
set.seed(1)
arr <- array(rnorm(12000),dim=c(40,25,30))
arr[25:33,12:20, 20:23] <- 10
# getting events
out <- get_clusters_3d(arr, thres=0.985)
mean_sd <- stats_3d(arr[1:20,1:6,1:8])
ftrs <- get_features_3d(out$data, out$cluster$cluster, mean_sd, win_size=40, tt=2 )
}
