% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler.R
\name{handler}
\alias{handler}
\alias{new_handler}
\alias{validate_handler}
\title{Handler Constructor}
\usage{
handler(type, FUN)

new_handler(type, FUN)

validate_handler(type, FUN)
}
\arguments{
\item{type}{A character string indicating the event type to handle.}

\item{FUN}{A function which use an obj and an event as input parameters and returns an object as output.}
}
\value{
The \code{handler()} function returns an object of type \code{handler}. A \code{handler} object
contains two elements: \code{type} and \code{FUN}. Type is a string indicating the type of event and FUN
is a \code{R} function with to params: \code{obj} and \code{event}. \code{obj} is any R object and
\code{event} is an \code{event} object returned by the \code{event()} function.
}
\description{
Construct a handler object.
}
\examples{

set_birth_date <- function(obj, event){
  obj$birthDate <- event$body$birthDate
  return(obj)
}

set_death_date <- function(obj, event){
  obj$deathDate <- event$body$deathDate
  return(obj)
}

birth_handler <- handler(type = 'BIRTH', FUN = set_birth_date)
birth_handler

death_handler <- handler(type = 'DEATH', FUN = set_death_date)
death_handler

}
