% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EkNNinit.R
\name{EkNNinit}
\alias{EkNNinit}
\title{Initialization of parameters for the EkNN classifier}
\usage{
EkNNinit(x, y, alpha = 0.95)
}
\arguments{
\item{x}{Input matrix of size n x d, where n is the number of objects and d the number of
attributes.}

\item{y}{Vector of class lables (of length n). May be a factor, or a vector of
integers.}

\item{alpha}{Parameter \eqn{\alpha}.}
}
\value{
A list with two elements:
  \describe{
  \item{gamma}{Vector of parameters \eqn{\gamma_k}, of length c, the number of classes.}
  \item{alpha}{Parameter \eqn{\alpha}, set to 0.95.}
 }
}
\description{
\code{EkNNinit} returns initial parameter values for the EkNN classifier.
}
\details{
Each parameter \eqn{\gamma_k} is set ot the inverse of the square root of the mean
Euclidean distances wihin class k. Note that \eqn{\gamma_k} here is the square root
of the \eqn{\gamma_k} as defined in (Zouhal and Denoeux, 1998). By default, parameter alpha is set
to 0.95. This value normally does not have to be changed.
}
\examples{
## Iris dataset
data(iris)
x<-iris[,1:4]
y<-iris[,5]
param<-EkNNinit(x,y)
param
}
\author{
Thierry Denoeux.
}
\references{
T. Denoeux. A k-nearest neighbor classification rule based on Dempster-Shafer
theory. IEEE Transactions on Systems, Man and Cybernetics, 25(05):804--813, 1995.

L. M. Zouhal and T. Denoeux. An evidence-theoretic k-NN rule with parameter
optimization. IEEE Transactions on Systems, Man and Cybernetics Part C,
28(2):263--271,1998.

Available from \url{https://www.hds.utc.fr/~tdenoeux}.
}
\seealso{
\code{\link{EkNNfit}}, \code{\link{EkNNval}}
}

