% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_latent_trawl.R
\name{PairwiseOneOne12}
\alias{PairwiseOneOne12}
\title{Computes second part of first term in latent trawl pairwise likelihood with \code{(x,x)} where \code{x} positive and \code{y} positive.}
\usage{
PairwiseOneOne12(x1, x2, alpha, beta, kappa, B2, trawlA)
}
\arguments{
\item{x1}{Positive value corresponding to \code{t1}.}

\item{x2}{Positive value corresponding to \code{t2}.}

\item{alpha}{Shape parameter. Should be positive.}

\item{beta}{Latent Gamma scale parameter. Should be positive.}

\item{kappa}{Exceedance probability parameter. Should be positive.}

\item{B2}{Intersection area between \code{t1} and \code{t2} (in this order).}

\item{trawlA}{Total trawl set measure / area under trawl function.}
}
\value{
Second part of first term in latent trawl pairwise likelihood with \code{(x,x)} where \code{x} positive and \code{y} positive.
}
\description{
Computes second part of first term in latent trawl pairwise likelihood with \code{(x,x)} where \code{x} positive and \code{y} positive.
}
