% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonize_country_code.R
\name{harmonize_country_code}
\alias{harmonize_country_code}
\title{Harmonize Country Code}
\usage{
harmonize_country_code(x)
}
\arguments{
\item{x}{A character or a factor vector of eurostat countycodes.}
}
\value{
a vector.
}
\description{
The European Commission and the Eurostat generally uses ISO
3166-1 alpha-2 codes with two exceptions: EL (not GR) is used to
represent Greece, and UK (not GB) is used to represent the
United Kingdom. This function turns country codes into to ISO
3166-1 alpha-2.
}
\examples{
\dontshow{if (check_access_to_data()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
lp <- get_eurostat("nama_10_lp_ulc")
lp$geo <- harmonize_country_code(lp$geo)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other helpers: 
\code{\link{cut_to_classes}()},
\code{\link{dic_order}()},
\code{\link{eurotime2date2}()},
\code{\link{eurotime2date}()},
\code{\link{eurotime2num2}()},
\code{\link{eurotime2num}()},
\code{\link{label_eurostat2}()},
\code{\link{label_eurostat}()}
}
\author{
Janne Huovari \href{mailto:janne.huovari@ptt.fi}{janne.huovari@ptt.fi}
}
\concept{helpers}
