% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eurotime2date.R
\name{eurotime2date}
\alias{eurotime2date}
\title{Date Conversion from Eurostat Time Format}
\usage{
eurotime2date(x, last = FALSE)
}
\arguments{
\item{x}{a charter string with time information in Eurostat time format.}

\item{last}{a logical. If \code{FALSE} (default) the date  is
the first date of the period (month, quarter or year). If \code{TRUE}
the date is the last date of the period.}
}
\value{
an object of class \code{\link[=Date]{Date()}}.
}
\description{
Date conversion from Eurostat time format. A function to
convert Eurostat time values to objects of class \code{\link[=Date]{Date()}}
representing calendar dates.
}
\examples{
\dontshow{if (check_access_to_data()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
na_q <- get_eurostat("namq_10_pc", time_format = "raw")
na_q$time <- eurotime2date(x = na_q$time)
unique(na_q$time)
}
\dontshow{\}) # examplesIf}
}
\references{
See \code{citation("eurostat")}:\preformatted{# 
# Kindly cite the eurostat R package as follows:
# 
#   (C) Leo Lahti, Janne Huovari, Markus Kainu, Przemyslaw Biecek.
#   Retrieval and analysis of Eurostat open data with the eurostat
#   package. R Journal 9(1):385-392, 2017. doi: 10.32614/RJ-2017-019
#   Package URL: http://ropengov.github.io/eurostat Article URL:
#   https://journal.r-project.org/archive/2017/RJ-2017-019/index.html
# 
# A BibTeX entry for LaTeX users is
# 
#   @Article\{,
#     title = \{Retrieval and Analysis of Eurostat Open Data with the eurostat Package\},
#     author = \{Leo Lahti and Janne Huovari and Markus Kainu and Przemyslaw Biecek\},
#     journal = \{The R Journal\},
#     volume = \{9\},
#     number = \{1\},
#     pages = \{385--392\},
#     year = \{2017\},
#     doi = \{10.32614/RJ-2017-019\},
#     url = \{https://doi.org/10.32614/RJ-2017-019\},
#   \}
}
}
\seealso{
\code{\link[lubridate:ymd]{lubridate::ymd()}}

Other helpers: 
\code{\link{cut_to_classes}()},
\code{\link{dic_order}()},
\code{\link{eurotime2num}()},
\code{\link{harmonize_country_code}()},
\code{\link{label_eurostat}()}
}
\author{
Janne Huovari \href{mailto:janne.huovari@ptt.fi}{janne.huovari@ptt.fi}
}
\concept{helpers}
