% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safety_summary.R
\name{safety_summary}
\alias{safety_summary}
\title{Calculate frequency tables from a rectangular data frame with one row per subject-event}
\usage{
safety_summary(
  data,
  exposed,
  excess_deaths = 0,
  freq_threshold = 0,
  soc_index = c("meddra", "soc_term")
)
}
\arguments{
\item{data}{a data set containing the following columns: \code{subjid, term, soc, serious, related, fatal, group}.
See \code{\link{safety}} for more details.}

\item{exposed}{a numeric vector giving the numbers of subjects exposed in each group.
This needs to be supplied directly by the user, and cannot be inferred from the input \code{data}
with one row per patient-event.
To ensure the ordering is correct either, name the vector with names matching the values in \code{data$group}, or
ensure that the data$group is an ordered factor, or relying on alphabetical ordering of the values in
\code{data$group}}

\item{excess_deaths}{a numeric vector giving the number of extra deaths not reported within \code{data}. Defaults to 0.}

\item{freq_threshold}{a value on a percentage scale at which to remove events if the incidence falls below. Defaults to 0}

\item{soc_index}{a character vector either "meddra" or "soc_term", which is used to identify if the soc variable in data gives the numerical meddra code or the description in English.}
}
\value{
a list of three dataframes: GROUP, SERIOUS, NON_SERIOUS. Each contains the summary statistics required by EudraCT, and is suitable for export.
}
\description{
Calculate frequency tables from a rectangular data frame with one row per subject-event
}
\examples{
safety_statistics <- safety_summary(safety,
                                    exposed=c("Experimental"=60,"Control"=67))
simple <- tempfile(fileext = ".xml")
eudract <- tempfile(fileext = ".xml")
simple_safety_xml(safety_statistics, simple)
eudract_convert(input=simple,
                output=eudract)
}
\seealso{
\code{\link{eudract_convert}} \code{\link{simple_safety_xml}}
}
