% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_schema}
\alias{get_schema}
\alias{get_schema.default}
\alias{get_schema.src_mysql}
\alias{get_schema.src_postgres}
\alias{get_schema.src_sqlite}
\title{Retrieve a pre-defined schema}
\usage{
get_schema(con, schema_name, pkg, ext = NULL, ...)

\method{get_schema}{default}(con, schema_name, pkg, ext = NULL, ...)

\method{get_schema}{src_sqlite}(con, schema_name, pkg, ext = NULL, ...)

\method{get_schema}{src_mysql}(con, schema_name, pkg, ...)

\method{get_schema}{src_postgres}(con, schema_name, pkg, ...)
}
\arguments{
\item{con}{A database connection}

\item{schema_name}{The name of the schema}

\item{pkg}{The package defining the schema}

\item{ext}{The file extension used for the SQL schema file}

\item{...}{Currently ignored}
}
\description{
If the table definitions are at all non-trivial,
you may wish to include a pre-defined table schema. This function
will retrieve it.
}
\examples{

cars <- etl("mtcars")
get_schema(cars, "mtcars", "etl")
}

