## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ethiodate)
eth_parse_date("2015-01-01")

## -----------------------------------------------------------------------------
eth_dates <- c("2015-01-01", "2015-02-15", "2015-13-05")
eth_parse_date(eth_dates)

## -----------------------------------------------------------------------------
x <- c("01/17/2025", "05/12/2017")
eth_parse_date(x, format = "%m/%d/%Y")

## -----------------------------------------------------------------------------
eth_parse_date("Meskerem 25, 2017", format = "%B %d, %Y")
eth_parse_date("መስከረም 25, 2017", format = "%B %d, %Y", lang = "amh")
eth_parse_date("Sep 25, 2017", format = "%b %d, %Y", lang = "en")

## -----------------------------------------------------------------------------
# The same origin
eth_parse_date("1962-04-23") |> unclass()
as.Date("1970-01-01") |> unclass()

## -----------------------------------------------------------------------------
eth_date(7, origin = eth_today())

## -----------------------------------------------------------------------------
eth_make_date(2017, 1, 1)

y <- c(2022, 2025)
m <- c(5, 9)
d <- c(15, 19)
eth_make_date(y, m, d)


## -----------------------------------------------------------------------------
# 2011 is leap year -> Correct
eth_date("2011-13-6")

# Incorrect
eth_date("2012-13-6")

## -----------------------------------------------------------------------------
gre_date <- as.Date("2025-01-15")
eth_date(gre_date)

## -----------------------------------------------------------------------------
eth_dt <- eth_date(0)
as.Date(eth_dt)

## -----------------------------------------------------------------------------
# Adding scalar days
eth_date("2010-09-14") + 6

# Subtraction
eth_date("2010-09-14") - 6

# Differences
eth_date("2010-09-14") - eth_date("2010-09-10")


## -----------------------------------------------------------------------------
format(eth_today(), format = "This documents was updated on %B %d, %Y EC.")

