context("test-set_email")
ess_email <- Sys.getenv("ESS_EMAIL")
save_dir <- tempdir()

# Test for set_email
test_that("test email is correctly set and can be overwritten", {
  skip_on_cran()
  old_env_var <- Sys.getenv("ESS_EMAIL")
  
  set_email(ess_email = "test@test.com")
  expect_equal(Sys.getenv("ESS_EMAIL"), "test@test.com")
  set_email(ess_email = "test_bis@test.com")
  expect_equal(Sys.getenv("ESS_EMAIL"), "test_bis@test.com")

  # Reset
  Sys.setenv("ESS_EMAIL" = old_env_var)
})

test_that("authenticate works correctly for wrong emails", {
  skip_on_cran()
  expect_error(authenticate("random@email.morerandom"),
               "email address you provided is not associated with any registered") # nolint
  
  expect_error(authenticate(""),
               "email address you provided is not associated with any registered") # nolint
})
