% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fan_beam.R
\name{fan.beam}
\alias{fan.beam}
\title{Creation of pyramid fan object with constant angle step.}
\usage{
fan.beam(
  alpha,
  dalpha,
  orientation = c(0, 0, 1, 1, 0, 0),
  origin = c(0, 0, 0),
  ref.pseudo = "",
  frame.of.reference = "",
  alias = "",
  description = "beam fan"
)
}
\arguments{
\item{alpha}{Positive number specifying the half-angle of the conical beam.}

\item{dalpha}{Positive number specifying the step of the angle between the
rays of the cone beam.}

\item{orientation}{Vector orientation of the pyramid base composed by the
2 orthonormal vectors coordinates.}

\item{origin}{Numeric vector, giving the xyz coordinates of the fan origin.
By default \code{c (0, 0, 0)}.}

\item{ref.pseudo}{Character string, frame of reference pseudonym of the
created object.}

\item{frame.of.reference}{Character string, frame of reference of the
created object.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the the created object.}
}
\value{
Returns a "fan" class object (see \link[espadon]{espadon.class}
for class definitions) containing, among others,
\itemize{
\item \code{$xyz} : a matrix of 3 columns giving the xyz coordinates of the fan rays.
\item \code{$local} : a matrix of 2 columns indicating the deflection angle (in rad) in
the main directions defined by \code{orientation}.
}
}
\description{
The \code{fan.beam} function creates a "fan" class object
containing, among others, the coordinates of the unit director vectors of
the rays of rectangular pyramid fan. Rays are uniformly distributed by angle.
}
\examples{
fan <- fan.beam (alpha = 30, dalpha = 1)
head (fan$xyz)
library (rgl)
open3d ()
points3d (fan$xyz)
}
\seealso{
\link[espadon]{fan.planar}, \link[espadon]{fan.sphere}, \link[espadon]{fan.to.voxel}.
}
