% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_3D_mesh.R
\name{display.3D.mesh}
\alias{display.3D.mesh}
\title{3D display of a mesh}
\usage{
display.3D.mesh(mesh, display.ref = mesh$ref.pseudo, T.MAT = NULL, ...)
}
\arguments{
\item{mesh}{"mesh" class object, created by the \link[espadon]{mesh.from.bin}
function. See \link[espadon]{espadon.class} for class definitions.}

\item{display.ref}{Character string. Pseudonym of the frame of reference used for display.}

\item{T.MAT}{"t.mat" class object, created by \link[espadon]{load.patient.from.Rdcm} or
\link[espadon]{load.T.MAT}. If \code{T.MAT} is \code{NULL}, \code{mesh} must be
displayed in \code{display.ref = mesh$ref.pseudo}.}

\item{...}{Additional arguments passed to \link[rgl]{shade3d} as \code{color}, \code{specular},
\code{alpha}...}
}
\value{
Returns a display of \code{mesh} in the current \pkg{RGL} window if it exists,
in a new window otherwise.
}
\description{
The \code{display.3D.mesh} function performs a 3D display of a mesh.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 4
patient <- toy.load.patient (modality = c("ct", "rtstruct"), roi.name = "",
                             dxyz = rep (step, 3))
CT <- patient$ct[[1]]
S <- patient$rtstruct[[1]]

# creation of the patient mesh
bin <- bin.from.roi (CT, struct = S, roi.name = "patient")
mesh.patient <- mesh.from.bin (bin, alias = "patient", verbose = FALSE)

# display of the patient mesh, with transparency
library (rgl)
open3d()
display.3D.mesh (mesh.patient, color = "burlywood2", specular = "#404040")
}
\seealso{
\link[espadon]{mesh.from.bin}.
}
