% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vol_from_bin.R
\name{vol.from.bin}
\alias{vol.from.bin}
\title{Volume class object according to binary selection}
\usage{
vol.from.bin(vol, sel.bin, alias = "", description = NULL)
}
\arguments{
\item{vol}{"volume" class object, containing data to restrict.}

\item{sel.bin}{"volume" class object, of "binary" modality.
\code{vol} and \code{sel.bin} must have the same grid.}

\item{alias}{Character string, \code{$alias} of the created object}

\item{description}{Character string, describing the created object.
If \code{description = NULL} (default value),
it will be set to \code{paste (vol$object.alias, "from", sel.bin$object.alias)}}
}
\value{
Returns a "volume" class object (see \link[espadon]{espadon.class}
for class definitions), in which non-selected voxels have the value \code{NA},
and selected voxels have the original value of \code{vol}.
}
\description{
The \code{vol.from.bin} function selects a part of a "volume"
class object of "binary" modality which has the same grid. It is especially
useful to restrict voxel data in region of interest.
}
\examples{
# loading of toy-patient objects (decrease dxyz for  better result)
patient <- toy.load.patient (modality = c ("ct", "rtstruct"), 
                             roi.name = "brain", dxyz = c (4, 4, 4))
CT <- patient$ct[[1]]
S <- patient$rtstruct[[1]]

# select the brain in the volume
bin.brain <- bin.from.roi (vol = CT, struct = S, roi.name = "brain")
vol.brain <- vol.from.bin (CT, bin.brain)
# display at the center of gravity of the brain Gz
Gz <- S$roi.info [grep("^brain", S$roi.info$roi.pseudo),]$Gz
display.plane (bottom = vol.brain, view.coord = Gz, struct = S,
               roi.sname = "brain", bg = "#00ff00", interpolate = FALSE)
}
