% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_intervals.R
\name{sort_distributions}
\alias{sort_distributions}
\title{Sort Distributions by Better Error Intervals}
\usage{
sort_distributions(phi, errors, dists = c("n", "nm", "l", "lm", "w", "b",
  "moge"), decreasing = FALSE, ...)
}
\arguments{
\item{phi}{residual values used to compute the error interval.}

\item{errors}{set of real errors corresponding to the predictions of a particular
model.}

\item{dists}{character vector with the distribution assumptions to test. See also
'Details'.}

\item{decreasing}{logical, indicating whether or not distributions should be 
ordered by decreasing accuracy error.}

\item{...}{additional arguments to be passed to functions \code{error_interval}
and \code{acc_intervals}.}
}
\value{
Returns an object of class \code{c("df_intervals", "data.frame")} with
information of the distribution assumptions ordered by accuracy error.
}
\description{
\code{sort_distributions} orders a given set of distribution assumptions
in order of intervals accuracy error in ascending or descending order.
}
\details{
Allowed distribution assumptions are:
\itemize{
 \item{"n": }{Zero-mu Gaussian}
 \item{"nm": }{General Gaussian}
 \item{"l": }{Zero-mu Laplace}
 \item{"lm": }{General Laplace}
 \item{"b": }{Beta}
 \item{"w": }{Weibull}
 \item{"moge": }{Moge}
}
}
\examples{
sort_distributions(rnorm(10),rnorm(10),decreasing=TRUE)
}
\author{
Jesus Prada, \email{jesus.prada@estudiante.uam.es}
}
\references{
Link to the scientific paper

Prada, Jesus, and Jose Ramon Dorronsoro. "SVRs and Uncertainty Estimates in Wind 
Energy Prediction." Advances in Computational Intelligence. Springer International 
Publishing, 2015. 564-577,

with theoretical background for this package is provided below.

\url{http://link.springer.com/chapter/10.1007/978-3-319-19222-2_47}
}
\seealso{
\link{df_intervals} \link{error_interval} \link{acc_intervals} \link{order}
}

