% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{m2star-ergmTerm}
\alias{m2star-ergmTerm}
\alias{InitErgmTerm.m2star}
\title{Mixed 2-stars, a.k.a 2-paths}
\usage{
# binary: m2star
}
\description{
This term adds one statistic to the model, equal to the number of mixed
2-stars in the network, where a mixed 2-star is a pair of distinct edges
\eqn{(i{\rightarrow}j), (j{\rightarrow}k)}{(i,j), (j,k)} . A mixed 2-star is
sometimes called a 2-path because it is a directed path of length 2 from
\eqn{i} to \eqn{k} via \eqn{j} . However, in the case of a 2-path the focus
is usually on the endpoints \eqn{i} and \eqn{k} , whereas for a mixed 2-star
the focus is usually on the midpoint \eqn{j} . This term can only be used
with directed networks; for undirected networks see \code{kstar(2)} . See
also \code{twopath} .
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "m2star", "subsection")}
}
\concept{directed}
