% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{gwb1degreeL-ergmTerm}
\alias{gwb1degreeL-ergmTerm}
\alias{InitErgmTerm.gwb1degreeL}
\title{Geometrically weighted degree distribution for the first mode in a bipartite (aka two-mode) network}
\usage{
# binary: gwb1degreeL(decay, fixed=FALSE, cutoff=30, levels=NULL, Ls=NULL)
}
\arguments{
\item{decay}{non-negative model parameter that is the same as theta_s in
equation (14) in Hunter (2007).}

\item{fixed}{specify if the value supplied for \code{decay} may be fixed (if \code{fixed=TRUE} ),
or it may be used as merely the starting value for the estimation
in a curved exponential family model (the default).}

\item{attrname}{if specified, then separate degree
statistics are calculated for nodes having each separate
value of the attribute.}

\item{cutoff}{only relevant if \code{fixed=FALSE} . In that case it only uses this
number of terms in computing the statistics to reduce the computational
burden. Its default value can also be controlled by the \code{gw.cutoff} term option control parameter. (See \code{\link{control.ergm}} .)}

\item{levels}{a list of layer specifications. If given, degree of a node
\code{i} is considered to be the number of edges in all layers,
combined.}

\item{Ls}{a list (constructed by \code{\link[=list]{list()}} or \code{\link[=c]{c()}} of one or more Layer Logic specifications (c.f. Layer Logic section in the \code{\link[=Layer]{Layer()}} documentation).}
}
\description{
This term adds one network statistic to the model equal to the weighted
degree distribution with decay controlled by the \code{decay} parameter, which should be non-negative,
for nodes in the
first mode of a bipartite network. The first mode of a bipartite network
object is sometimes known as the "actor" mode.

This term can only be used with undirected bipartite
networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "gwb1degreeL", "subsection")}
}
\concept{bipartite}
\concept{curved}
\concept{undirected}
