% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.multinet.R,
%   R/InitWtErgmTerm.multinet.R
\name{N-ergmTerm}
\alias{N-ergmTerm}
\alias{InitErgmTerm.N}
\alias{InitWtErgmTerm.N}
\title{Evaluation on multiple networks}
\usage{
# binary: N(formula, lm=~1, subset=TRUE, weights=1, contrasts=NULL, offset=0, label=NULL,
#           .NetworkID=".NetworkID", .NetworkName=".NetworkName")

# valued: N(formula, lm=~1, subset=TRUE, weights=1, contrasts=NULL, offset=0, label=NULL,
#           .NetworkID=".NetworkID", .NetworkName=".NetworkName")
}
\arguments{
\item{.NetworkID, .NetworkName}{Optional strings indicating the
vertex attributes used to distinguish and name the networks;
intended to be used by term developers.}

\item{formula}{a one-sided \code{\link[=ergm]{ergm()}}-style formula with the terms to be evaluated}

\item{lm}{a one-sided \code{\link[=lm]{lm()}}-style formula whose RHS specifies the network-level predictors for the terms in the \code{\link[=ergm]{ergm()}} formula \code{formula}.}

\item{subset, contrasts}{see \code{\link[=lm]{lm()}}.}

\item{offset}{A constant, a vector of length equal to the number of networks, or a matrix whose number of rows is the number of networks and whose number of columns is the number of free parameters of the ERGM. It can be specified in \code{lm} as well.}

\item{weights}{reserved for future use; attempting to change it will cause an
error: at this time, there is no way to assign sampling weights to
networks.}

\item{label}{An optional parameter which will add a label to model
parameters to help identify the term (which may have similar
predictors but, say, a different network subset) in the output
\emph{or} a function that wraps the names.}
}
\description{
Evaluates the terms in \code{formula} on each of the networks joined
using \code{\link{Networks}} function, and returns either a weighted
sum or an \code{\link{lm}}-style linear model for the ERGM
coefficients \insertCite{KrCo22t}{ergm.multi}. Its syntax follows that of \code{\link{lm}} closely,
with sensible defaults.

The default formula (\code{~1}) sums the specified network
statistics. If \code{lm} refers to any network attributes for which some
networks have missing values, the term will stop with an
error. This can be avoided by pre-filtering with \code{subset}, which
controls which networks are affected by the term.
}
\note{
Care should be taken to avoid multicollinearity when using
this operator. As with the \code{\link[=lm]{lm()}} function, \code{lm} formulas have an
implicit intercept, which can be suppressed by specifying \code{~ 0 + ...} or \code{~ -1 + ...} on the formula. When \code{lm} is given a model
with intercept and a categorical predictor (including a
\code{\link{logical}} one), it will use the first level (or \code{FALSE}) as the
baseline, but if the model is without intercept, it will use all
levels of the first categorical predictor. This is typically what
is wanted in a linear regression, but for the \code{N} operator, this
can be problematic if the "intercept" effect is added by a
different term. A workaround is to convert the categorical
predictor to dummy variables before putting it into the \code{lm}
formula.
}
\section{Offsets and fixing parameters}{


By default, an \code{N(formula, lm)} term will add \eqn{p \times q}{p*q} free
parameters, where \eqn{p} is the number of free parameters
(possibly curved) of the ERGM specified by \code{formula}, and \eqn{q}
is the number of parameters specified by the \code{lm} formula. That is,
there would be one parameter for each combination of an ERGM
parameter and a linear model parameter, in an ERGM-major order
(i.e., for each ERGM parameter, the linear model parameters will be
enumerated). For example, the term \code{gwesp()} has two free
parameters: its coefficient and its decay rate. We can specify a
model in which they depend on \eqn{\log(n)} as \code{N(~gwesp, ~log(n))}, resulting in the following 4 parameters, with the
intercept for the linear model being implicit:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "N(1)~gwesp"            "N(log(n))~gwesp"       "N(1)~gwesp.decay"     
#> [4] "N(log(n))~gwesp.decay"
}\if{html}{\out{</div>}}

If a different linear model is desired for different ERGM terms
(e.g., some are to be affected by network size while others are
not), multiple \code{N()} terms can be specified. This covers most such
cases, but not all. For example, suppose that for the above model,
we wish for its coefficient to depend on \code{log(n)} but for the decay
parameter not to. In this case, one can use the \code{offset()}
decorator with partial offsetting. Then, specifying
\code{offset(N(~gwesp(), ~log(n)), 4)}, we get:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "N(1)~gwesp"                    "N(log(n))~gwesp"              
#> [3] "N(1)~gwesp.decay"              "offset(N(log(n))~gwesp.decay)"
}\if{html}{\out{</div>}}

Then, setting the corresponding \code{offset.coef = 0} will fix the
coefficient of \code{log(n)} for the decay parameter at 0, while
allowing a constant decay parameter to be estimated.
}

\references{
\insertAllCited{}
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "N", "subsection")}

\code{vignette("Goeyvaerts_reproduction")} for a demonstration.
}
\concept{directed}
\concept{operator}
\concept{undirected}
