% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQ_functions.R
\name{eqvs_add}
\alias{eqvs_add}
\title{eqvs_add}
\usage{
eqvs_add(
  df,
  version = "5L",
  country = NULL,
  saveOption = 1,
  savePath = NULL,
  description = NULL,
  code2L = NULL,
  code3L = NULL
)
}
\arguments{
\item{df}{A data.frame or file name pointing to csv file. The contents of the data.frame or csv file should be exactly two columns: state, containing a list of all 3125 (for 5L) or 243 (for 3L) EQ-5D health state vectors, and a column of corresponding utility values, with a suitable name.}

\item{version}{Version of the EQ-5D instrument. Can take values 5L (default) or 3L.}

\item{country}{Optional string. If not NULL, will be used as a country description for the user-defined value set.}

\item{saveOption}{Integer indicating how the cache data should be saved. 1: Do not save (default), 2: Save in package folder, 3: Save in another path.}

\item{savePath}{A path where the cache data should be saved when `saveOption` is 3. Please use `eqvs_load` to load it in your next session.}

\item{description}{Optional string. If not NULL, will be used as a descriptive text for the user-defined value set.}

\item{code2L}{Optional string. If not NULL, will be used as the two-digit code for the value set. Must be different from any existing national value set code.}

\item{code3L}{Optional string. If not NULL, will be used as the three-digit code for the value set. Must be different from any existing national value set code.}
}
\value{
True/False, indicating success or error.
}
\description{
Add user-defined EQ-5D value set and corresponding crosswalk option.
}
\examples{
# make nonsense value set
new_df <- data.frame(state = make_all_EQ_indexes(), TEST = runif(3125))
# Add as value set for Fantasia
eqvs_add(new_df, version = "5L", country = 'Fantasia', saveOption = 1)
}
