% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betadiv_disparity.R
\name{betadiv_disparity}
\alias{betadiv_disparity}
\title{Map change in morphological disparity}
\usage{
betadiv_disparity(x, radius, slow = FALSE, nThreads = 1)
}
\arguments{
\item{x}{object of class \code{epmGrid}.}

\item{radius}{Radius of the moving window in map units.}

\item{slow}{if TRUE, use an alternate implementation that has a smaller
memory footprint but that is likely to be much slower. Most useful for
high spatial resolution.}

\item{nThreads}{number of threads for parallelization}
}
\value{
Returns a sf polygons object (if hex grid) or a SpatRaster object
  (if square grid).
}
\description{
Change in morphological disparity is calculating across a
  moving window of neighboring grid cells. To implement a custom function,
	  see \code{\link{customBetaDiv}}.
}
\details{
For each gridcell neighborhood (defined by the radius), we
calculate the proportion of the full disparity contained in those grid
cells, and then take the standard deviation of those proportions across the
gridcell neighborhood. This way, the returned values reflect how much
disparity (relative to the overall total disparity) changes across a moving
window.

If the R package spdep is installed, this function should run more quickly.
}
\examples{
\donttest{
tamiasEPM

tamiasEPM <- addTraits(tamiasEPM, tamiasTraits)

z <- betadiv_disparity(tamiasEPM, radius = 150000)

plot(z)

# using square grid epmGrid
tamiasEPM2 <- createEPMgrid(tamiasPolyList, resolution = 50000,
	cellType = 'square', method = 'centroid')
tamiasEPM2 <- addTraits(tamiasEPM2, tamiasTraits)
z2 <- betadiv_disparity(tamiasEPM2, radius = 150000)

terra::plot(z2, col = sf::sf.colors(100))

}
}
\references{
Foote M. 1993. Contributions of individual taxa to overall morphological
disparity. Paleobiology. 19:403–419.
}
\author{
Pascal Title
}
