% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/err.R
\name{read_err}
\alias{read_err}
\title{Read an EnergyPlus Simulation Error File}
\usage{
read_err(path)
}
\arguments{
\item{path}{a file path of EnergyPlus simulation error file, usually
with an extension \code{.err}.}
}
\value{
An \code{ErrFile} object.
}
\description{
\code{read_err()} takes a file path of EnergyPlus simulation error file, usually
with an extension \code{.err}, parses it and returns an \code{ErrFile} object.
}
\details{
Basically, an \code{ErrFile} object is a \link[data.table:data.table]{data.table}
with 6 columns and 6 additional attributes:

6 Columns:
\itemize{
\item \code{index}: Integer. Index of messages.
\item \code{envir_index}: Integer. Index of simulation environments.
\item \code{envir}: Character. Names of simulation environments.
\item \code{level_index}: Integer. Index for each severe level.
\item \code{level}: Character. Name of severe levels. Possible values: \code{Info},
\code{Warning}, \code{Severe}, and etc.
\item \code{message}: Character. Error messages.
}

6 Attributes:
\itemize{
\item \code{path}: A single string. The path of input file.
\item \code{eplus_version}: A \link[base:numeric_version]{numeric_version} object. The
version of EnergyPlus used during the simulation.
\item \code{eplus_build}: A single string. The build tag of EnergyPlus used during the
simulation.
\item \code{datetime}: A DateTime (POSIXct). The time when the simulation started.
\item \code{idd_version}: A \link[base:numeric_version]{numeric_version}. The version of
IDD used during the simulation.
\item \code{successful}: \code{TRUE} when the simulation ended successfully, and \code{FALSE}
otherwise.
\item \code{terminated}: \code{TRUE} when the simulation was terminated, and \code{FALSE}
otherwise.
}
}
\examples{
\dontrun{
# run simulation and get the err file
idf_name <- "1ZoneUncontrolled.idf"
epw_name <-  "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw"
idf_path <- file.path(eplus_config(8.8)$dir, "ExampleFiles", idf_name)
epw_path <- file.path(eplus_config(8.8)$dir, "WeatherData", epw_name)
job <- eplus_job(idf_path, epw_path)
job$run(dir = tempdir())

# read the err file
read_err(job$locate_output(".err"))
}
}
