% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idd_object.R
\name{as.character.IddObject}
\alias{as.character.IddObject}
\title{Coerce an IddObject into a Character Vector}
\usage{
\method{as.character}{IddObject}(x, comment = NULL, leading = 4L, sep_at = 29L, all = FALSE, ...)
}
\arguments{
\item{x}{An \link{IddObject} object.}

\item{comment}{A character vector to be used as comments of returned string
format object. If \code{NULL}, no comments are inserted. Default: \code{NULL}.}

\item{leading}{Leading spaces added to each field. Default: \code{4}.}

\item{sep_at}{The character width to separate value string and field string.
Default: \code{29} which is the same as IDF Editor.}

\item{all}{If \code{TRUE}, all fields in current class are returned, otherwise
only minimum fields are returned.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A character vector.
}
\description{
Coerce an \link{IddObject} into an empty object of current class in a character
vector format. It is formatted exactly the same as in IDF Editor.
}
\examples{
\dontrun{
as.character(use_idd(8.8, download = "auto")$Materal, leading = 0)
}

}
