% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wages.r
\name{get_median_and_mean_wages}
\alias{get_median_and_mean_wages}
\title{Retreive the hourly wage in the middle of the wage distribution}
\usage{
get_median_and_mean_wages(by = NULL)
}
\arguments{
\item{by}{\code{NULL} or character string with any combination of \code{g} (Gender),
\code{r} (Race), \code{e} (Education), \code{d} (Percentile), \code{l} (Entry-level)
i.e. if you want to wage data by gender and race, you would set this
parameter to "\code{gr}".}
}
\value{
\code{tbl_df} with data filtered by the selected criteria.
}
\description{
The median wage is the hourly wage in the middle of the wage distribution;
50 percent of wage earners earn less and 50 percent earn more. The average wage is
the arithmetic mean of hourly wages; or, the sum of all workers' hourly wages divided
by the number of workers.
}
\examples{
get_median_and_mean_wages()

get_median_and_mean_wages("r")

get_median_and_mean_wages("gr")
}
\references{
\href{http://www.epi.org/data/}{Economic Policy Institute Data Library}
}
