% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monthlyPET.R
\name{monthlyPET}
\alias{monthlyPET}
\title{monthly PET}
\usage{
monthlyPET(Tmean, RA, TD, tempScale = 1)
}
\arguments{
\item{Tmean}{rasterStack of monthly mean temperature}

\item{RA}{rasterStack of monthly extraterrestrial solar radiation}

\item{TD}{rasterStack of monthly temperature range}

\item{tempScale}{integer; scaling factor for the temperature data, see \link{envirem} for 
additional details.}
}
\value{
rasterStack of monthly PET in mm / month
}
\description{
Monthly potential evapotranspiration
}
\details{
\code{PET = 0.0023 * RA * (Tmean + 17.8) * TD ^ 0.5}
}
\examples{
\donttest{
# Find example rasters
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)
env <- stack(rasterFiles)

# identify the appropriate layers
meantemp <- grep('mean', names(env), value=TRUE)
solar <- grep('solrad', names(env), value=TRUE)
maxtemp <- grep('tmax', names(env), value=TRUE)
mintemp <- grep('tmin', names(env), value=TRUE)

# read them in as rasterStacks
meantemp <- stack(env[[meantemp]])
solar <- stack(env[[solar]])
maxtemp <- stack(env[[maxtemp]])
mintemp <- stack(env[[mintemp]])
tempRange <- abs(maxtemp - mintemp)

monthlyPET(meantemp, solar, tempRange, tempScale = 10)
}

}
\references{
Hargreaves, G. L., Hargreaves, G. H., & Riley, J. P. (1985). Irrigation water requirements 
for Senegal River basin. \emph{Journal of Irrigation and Drainage Engineering}, 
\strong{111}, 265-275.

Zomer, R.J., Trabucco, A., Bossio, D.A. & Verchot, L.V. (2008). Climate change mitigation: 
A spatial analysis of global land suitability for clean development mechanism afforestation
and reforestation. \emph{Agriculture, Ecosystems and Environment}, \strong{126}, 67-80.

Zomer, R.J., Trabucco, A., Van Straaten, O. & Bossio, D.A. (2006) \emph{Carbon, Land and Water: 
A Global Analysis of the Hydrologic Dimensions of Climate Change Mitigation through
Afforestation/Reforestation. International Water Management Institute Research Report 101}.
Colombo, Sri Lanka.
}
\author{
Pascal Title
}
