% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/within.R
\name{within.environment}
\alias{within.environment}
\alias{within.character}
\title{\code{within} methods for \R environments}
\usage{
\method{within}{environment}(data, expr, ..., quote = substitute(expr))

\method{within}{character}(
  data,
  expr,
  ...,
  pos = 2L,
  warn.conflicts = TRUE,
  mask.ok = NULL,
  quote = substitute(expr)
)
}
\arguments{
\item{data}{An \R environment, or the name of a (potentially new) attached
environment.}

\item{expr}{The bare \R expression to evaluate. Automatically quoted.}

\item{...}{Ignored. Added for compatibility with the S3 generic. Throws an
error if any arguments are passed to \code{...}.}

\item{quote}{An R language object. This is an escape hatch from the automatic
quoting of \code{expr}.}

\item{pos}{The position where to attach the environment, if creating a new
one. If an environment of \code{name} already exists, \code{pos} is ignored.}

\item{warn.conflicts}{logical. If TRUE (the default), print warnings about
objects in the attached environment that that are masking or masked by
other objects of the same name.}

\item{mask.ok}{character vector of names of objects that can mask objects on
the search path without signaling a warning if \code{warn.conflicts} is \code{TRUE}.}
}
\value{
The \R environment, invisibly.
}
\description{
\code{within} methods for \R environments
}
\details{
The only difference between \code{attach_eval} and \code{within.character} is
the order of the arguments and the return value; the first
returns the result of evaluating the expression, the latter the
environment.
}
\note{
See the note in \code{attach_source} about a potential pitfall of evaluating
code directly in an attached environment.
}
\seealso{
\link{attach_eval} \link{attach_source} \link{eval} \link{within}
}
