% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recplot2.R
\name{enve.recplot2.findPeaks.em}
\alias{enve.recplot2.findPeaks.em}
\title{Enveomics: Recruitment Plot (2) Em Peak Finder}
\usage{
enve.recplot2.findPeaks.em(x, max.iter = 1000, ll.diff.res = 1e-08,
  components = 2, rm.top = 0.05, verbose = FALSE, init, log = TRUE)
}
\arguments{
\item{x}{An \code{\link{enve.RecPlot2}} object.}

\item{max.iter}{Maximum number of EM iterations.}

\item{ll.diff.res}{Maximum Log-Likelihood difference to be considered as convergent.}

\item{components}{Number of distributions assumed in the mixture.}

\item{rm.top}{Top-values to remove before finding peaks, as a quantile probability.
This step is useful to remove highly conserved regions, but can be
turned off by setting \code{rm.top=0}. The quantile is determined 
\strong{after} removing zero-coverage windows.}

\item{verbose}{Display (mostly debugging) information.}

\item{init}{Initialization parameters. By default, these are derived from k-means
clustering. A named list with vectors for \code{mu}, \code{sd}, and 
\code{alpha}, each of length \code{components}.}

\item{log}{Logical value indicating if the estimations should be performed in
natural logarithm units. Do not change unless you know what you're
doing.}
}
\value{
Returns a list of \code{\link{enve.RecPlot2.Peak}} objects.
}
\description{
Identifies peaks in the population histogram using a Gaussian Mixture
Model Expectation Maximization (GMM-EM) method.
}
\author{
Luis M. Rodriguez-R [aut, cre]
}
