% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biprobit.R
\name{biprobit}
\alias{biprobit}
\title{Recusrive Bivariate Probit Model}
\usage{
biprobit(
  form1,
  form2,
  data = NULL,
  par = NULL,
  method = "BFGS",
  verbose = 0,
  accu = 10000
)
}
\arguments{
\item{form1}{Formula for the first probit model}

\item{form2}{Formula for the second probit model}

\item{data}{Input data, a data frame}

\item{par}{Starting values for estimates}

\item{method}{Optimization algorithm. Default is BFGS}

\item{verbose}{Level of output during estimation. Lowest is 0.}

\item{accu}{1e12 for low accuracy; 1e7 for moderate accuracy; 10.0 for extremely high accuracy. See optim}
}
\value{
A list containing the results of the estimated model
}
\description{
Estimate two probit models with bivariate normally distributed error terms. This command still works if the first-stage dependent variable is not a regressor in the second stage.
}
\examples{
library(MASS)
N = 2000
rho = -0.5
set.seed(1)

x = rbinom(N, 1, 0.5)
z = rnorm(N)

e = mvrnorm(N, mu=c(0,0), Sigma=matrix(c(1,rho,rho,1), nrow=2))
e1 = e[,1]
e2 = e[,2]

y1 = as.numeric(1 + x + z + e1 > 0)
y2 = as.numeric(1 + x + z + y1 + e2 > 0)

est = biprobit(y1~x+z, y2~x+z+y1)
est$estimates
}
\references{
Peng, Jing. (2022) Identification of Causal Mechanisms from Randomized Experiments: A Framework for Endogenous Mediation Analysis. Information Systems Research (Forthcoming), Available at SSRN: https://ssrn.com/abstract=3494856
}
\seealso{
Other endogeneity: 
\code{\link{bilinear}()},
\code{\link{biprobit_latent}()},
\code{\link{biprobit_partial}()},
\code{\link{pln_linear}()},
\code{\link{pln_probit}()},
\code{\link{probit_linear_latent}()},
\code{\link{probit_linear_partial}()},
\code{\link{probit_linear}()}
}
\concept{endogeneity}
