% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{airbnb_listings}
\alias{airbnb_listings}
\alias{airbnb_reviews}
\title{Airbnb listings and reviews}
\format{
\subsection{\code{airbnb_listings}}{

A data.frame with 1623 rows and 68 columns
\describe{
\item{id}{Airbnb's unique identifier for the listing.}
\item{name}{Name of the listing.}
\item{description}{Detailed description of the listing.}
\item{neighborhood_overview}{Host's description of the neighbourhood.}
\item{picture_url}{URL to the Airbnb hosted regular sized image for the listing.}
\item{host_id}{Airbnb's unique identifier for the host/user.}
\item{host_name}{Name of the host. Usually just the first name(s).}
\item{host_since}{The date the host/user was created. For hosts that are Airbnb guests this could be the date they registered as a guest.}
\item{host_location}{The host's self reported location.}
\item{host_about}{Description about the host.}
\item{host_response_time}{The time interval between when a host responds to an inquiry from a guest.}
\item{host_response_rate}{Percentage of inquiries from potential guests that are responded to by hosts.}
\item{host_acceptance_rate}{That rate at which a host accepts booking requests.}
\item{host_is_superhost}{Whether the host is a super host or not.}
\item{host_thumbnail_url}{A thumbnail of the host.}
\item{host_picture_url}{A URL to the picture of the host.}
\item{host_neighbourhood}{The host neighbourhood.}
\item{host_listings_count}{The number of listings the host has.}
\item{host_total_listings_count}{The number of listings the host has.}
\item{host_verifications}{Host communication verifications.}
\item{host_has_profile_pic}{Whether the host has a profile pic.}
\item{host_identity_verified}{Whether the host has their identity verified.}
\item{neighbourhood_cleansed}{The neighbourhood as geocoded using the latitude and longitude against neighborhoods as defined by open or public digital shapefiles.}
\item{latitude}{Uses the World Geodetic System (WGS84) projection for latitude and longitude.}
\item{longitude}{Uses the World Geodetic System (WGS84) projection for latitude and longitude.}
\item{property_type}{Self selected property type. Hotels and Bed and Breakfasts are described as such by their hosts in this field.}
\item{room_type}{Entire home/apt, Private room, Shared room, or Hotel. Entire places are best if you're seeking a home away from home. With an entire place, you'll have the whole space to yourself. This usually includes a bedroom, a bathroom, a kitchen, and a separate, dedicated entrance.
Hosts should note in the description if they'll be on the property or not (ex: "Host occupies first floor of the home"), and
provide further details on the listing. Private rooms are great for when you prefer a little privacy, and still value a local connection. When you book a private room, you'll have your own private room for sleeping and may share some spaces with others. You might need to walk through indoor spaces that another host or guest may occupy to get to your room. Shared rooms are for when you don't mind sharing a space with others. When you book a shared room, you'll be sleeping in a space that is shared with others and share the entire space with other people. Shared rooms are popular among flexible travelers looking for new friends and budget-friendly stays.}
\item{accommodates}{The maximum capacity of the listing.}
\item{bathrooms}{The number of bathrooms in the listing.}
\item{bathrooms_text}{The text of the number of bathsroom in the listings.}
\item{bedrooms}{The number of bedrooms.}
\item{beds}{The number of bed(s).}
\item{amenities}{The amenities.}
\item{price}{Daily price in local currency.}
\item{minimum_nights}{Minimum number of night stay for the listing.}
\item{maximum_nights}{Maximum number of night stay for the listing.}
\item{minimum_minimum_nights}{The smallest minimum_night value from the calender (looking 365 nights in the future).}
\item{maximum_minimum_nights}{The largest minimum_night value from the calender (looking 365 nights in the future).}
\item{minimum_maximum_nights}{The smallest maximum_night value from the calender (looking 365 nights in the future).}
\item{maximum_maximum_nights}{The largest maximum_night value from the calender (looking 365 nights in the future).}
\item{minimum_nights_avg_ntm}{The average minimum_night value from the calender (looking 365 nights in the future).}
\item{maximum_nights_avg_ntm}{The average maximum_night value from the calender (looking 365 nights in the future).}
\item{has_availability}{Whether there is availability or not.}
\item{availability_30}{The availability of the listing x days in the future as determined by the calendar. Note a listing may not be available because it has been booked by a guest or blocked by the host.}
\item{availability_60}{}
\item{availability_90}{}
\item{availability_365}{}
\item{number_of_reviews}{The number of reviews the listing has.}
\item{number_of_reviews_ltm}{The number of reviews the listing has (in the last 12 months).}
\item{number_of_reviews_l30d}{The number of reviews the listing has (in the last 30 days).}
\item{first_review}{The date of the first/oldest review.}
\item{last_review}{The date of the last/newest review.}
\item{review_scores_rating}{The review score for ratings of the listing.}
\item{review_scores_accuracy}{The review score for accuracy of the listing.}
\item{review_scores_cleanliness}{The review score for cleanliness of the listing.}
\item{review_scores_checkin}{The review score for checkin experience of the listing.}
\item{review_scores_communication}{The review score for communication of the listing.}
\item{review_scores_location}{The review score for location of the listing.}
\item{review_scores_value}{The review score for value of the listing.}
\item{license}{The licence/permit/registration number.}
\item{instant_bookable}{Whether the guest can automatically book the listing without the host requiring to accept their booking request. An indicator of a commercial listing.}
\item{calculated_host_listings_count}{The number of listings the host has in the current scrape, in the city/region geography.}
\item{calculated_host_listings_count_entire_homes}{The number of Entire home/apt listings the host has in the current scrape, in the city/region geography.}
\item{calculated_host_listings_count_private_rooms}{The number of Private room listings the host has in the current scrape, in the city/region geography.}
\item{calculated_host_listings_count_shared_rooms}{The number of Shared room listings the host has in the current scrape, in the city/region geography.}
\item{reviews_per_month}{The average number of reviews per month the listing has over the lifetime of the listing.}
}
}

\subsection{\code{airbnb_reviews}}{

A data.frame with 5679 rows and 6 columns
\describe{
\item{listing_id}{Unique identifier for the listing}
\item{id}{Unique identifier for the review}
\item{date}{Date of the review}
\item{reviewer_id}{Unique identifier for the reviewer}
\item{reviewer_name}{Name of the reviewer}
\item{comments}{Text of the review}
}
}
}
\source{
https://insideairbnb.com/get-the-data/
}
\usage{
airbnb_listings

airbnb_reviews
}
\description{
A sample dataset of Airbnb listings and reviews
of properties from Sydney, Australia.
}
\keyword{datasets}
