% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.nests.R
\name{info.nests}
\alias{info.nests}
\title{Calculte statistics about nests}
\usage{
info.nests(x = NULL, parameters = NULL, NestsResult = NULL,
  fixed.parameters = NULL, SE = NULL, temperatures = NULL,
  derivate = NULL, test = NULL, stopattest = FALSE, M0 = NULL,
  series = "all", TSP.borders = NULL,
  embryo.stages = "Caretta caretta.SCL", replicate.CI = 1, weight = NULL,
  out = "Likelihood", fill = NULL, SexualisationTRN = NULL,
  metric.end.incubation = NULL, metabolic.heating = 0,
  temperature.heterogenetity = 0, progress = FALSE, warnings = TRUE,
  parallel = TRUE)
}
\arguments{
\item{x}{A set of parameters if parameter NestsResult is not provided.}

\item{parameters}{A set of parameters if parameter NestsResult is not provided. (same as x)}

\item{NestsResult}{A NestsResult file generated by searchR}

\item{fixed.parameters}{Another set of parameters if result is not provided.}

\item{SE}{Standard error for each parameter if result is not provided, or replace the one in NestsResult. Use SE=NA to remove SE from NestResult}

\item{temperatures}{Timeseries of temperatures formatted using formatNests(). Will replace the one in result.}

\item{derivate}{Function used to fit embryo growth: dydt.Gompertz, dydt.exponential or dydt.linear}

\item{test}{Mean and SD of size of hatchlings}

\item{stopattest}{TRUE or FALSE. If TRUE, the model stops when proxy of size reached the mean test size.}

\item{M0}{Measure of hatchling size proxi at laying date}

\item{series}{The name or number of the series to be estimated.}

\item{TSP.borders}{The limits of TSP in stages. See embryo.stages parameter.}

\item{embryo.stages}{The embryo stages. At least TSP.borders stages must be provided to estimate TSP borders. See note.}

\item{replicate.CI}{Number of replicates to estimate CI. If 1, no CI is estimated.}

\item{weight}{Weights of the different nests to estimate likelihood}

\item{out}{Can take the values of likelihood or metric or summary. metric and summary can be combined: c("metric", "summary")}

\item{fill}{Number of minutes between two records. Create new one if they do not exist. NULL does not change the time of temperature recordings.}

\item{SexualisationTRN}{A set of parameters used to model thermal reaction norm during TSP}

\item{metric.end.incubation}{The expected metric at the end of incubation. Used to calibrate TSP size. If NULL, take the maximum Mean of the test parameter. If NA, use the actual final size. Can be a vector and is recycled if necessary.}

\item{metabolic.heating}{Degrees Celsius to be added at the end of incubation due to metabolic heating.}

\item{temperature.heterogenetity}{SD of heterogeneity of temperatures.}

\item{progress}{If FALSE, the progress bar is not shown (useful for using with sweave or knitr)}

\item{warnings}{If FALSE, does not show warnings}

\item{parallel}{If TRUE use parallel version for nests estimation}
}
\value{
Return or the total likelihood or a list with $metric and $summary depending on out parameter
}
\description{
This function calculates many statistics about nests.\cr
The embryo.stages is a list with stage numbers and relative size as compared to final size at the beginning of the stage.\cr
For example embryo.stages=list(number=21:30, size=c(8.4, 9.4, 13.6, 13.8, 18.9, 23.5, 32.2, 35.2, 35.5, 38.5)/39.33) indicates that the stages 21 begins at the relative size of 8.4/39.33.\cr
Series can be indicated as the name of the series, their numbers or series or sucession of TRUE or FALSE. "all" indicates that all series must be analyzed.\cr
The likelihood object is just the total likelihood of the data in the model.\cr
The summary object is a data.frame composed of these elements:
\itemize{
  \item \code{TimeWeighted.temperature.mean} Average temperature weigthed by the time at each temperature
  \item \code{TimeWeighted.temperature.se} Standard error for the average temperature weigthed by the time at each temperature
  \item \code{TSP.TimeWeighted.temperature.mean} Average temperature during the TSP weigthed by the time at each temperature
  \item \code{TSP.TimeWeighted.temperature.se} Standard error for the average temperature during the TSP weigthed by the time at each temperature
  \item \code{TSP.MassWeighted.temperature.mean} Average temperature during the TSP weigthed by the mass increase at each temperature
  \item \code{TSP.MassWeighted.temperature.se} Standard error for the average temperature during the TSP weigthed by the mass increase at each temperature
  \item \code{TSP.STRNWeighted.temperature.mean} Averaged temperature during the TSP weighted by sexualisation thermal reaction norm
  \item \code{TSP.STRNWeighted.temperature.se} Standard error for temperature during the TSP weighted by sexualisation thermal reaction norm
  \item \code{TSP.MassWeighted.STRNWeighted.temperature.mean} Averaged temperature during the TSP weighted by sexualisation thermal reaction norm and embryo growth
  \item \code{TSP.MassWeighted.STRNWeighted.temperature.se} Standard error for temperature during the TSP weighted by sexualisation thermal reaction norm and embryo growth
  \item \code{TSP.length.mean} Average length of the TSP
  \item \code{TSP.length.se} Standard error for length of the TSP
  \item \code{TSP.begin.mean} Average time of the beginning of the TSP
  \item \code{TSP.begin.se} Standard error for the beginning of the TSP
  \item \code{TSP.end.mean} Average time of the endd of the TSP
  \item \code{TSP.end.se} Standard error for the end of the TSP
  \item \code{Incubation.length.mean} Average number of days for the incubation length
  \item \code{Incubation.length.se} Standard error for number of days for the incubation length
  \item \code{Middlethird.begin.mean} Average day at which the middle third incubation begins
  \item \code{Middlethird.begin.se} Standard error for day at which the middle third incubation begins
  \item \code{Middlethird.end.mean} Average day at which the middle third incubation ends
  \item \code{Middlethird.end.se} Standard error at which the middle third incubation ends
  \item \code{Middlethird.length.mean} Average days for second third of incubation
  \item \code{Middlethird.length.se} Standard error for second third of incubation
  \item \code{MiddleThird.TimeWeighted.temperature.mean} Average temperature during the middle third of incubation
  \item \code{MiddleThird.TimeWeighted.temperature.se} Standard error for the temperature during the middle third of incubation
  \item \code{MiddleThird.MassWeighted.temperature.mean} Average temperature during the middle third of incubation weight by embryo growth
  \item \code{MiddleThird.MassWeighted.temperature.se} Standard error for temperature during the middle third of incubation weight by embryo growth
}
The metric object is a list composed of data.frames which have the following attributes for each element of the list:
\itemize{
  \item \code{time.begin.tsp} Average time at the beginning of TSP
  \item \code{time.end.tsp} Average time at the end of TSP
  \item \code{time.begin.middlethird} Average time at the beginning of the middle third of incubation
  \item \code{time.begin.middlethird} Average time at the end of the middle third of incubation
  \item \code{time.begin.tsp.se} Standard error for the time at the beginning of TSP
  \item \code{time.end.tsp.se} Standard error for the time at the end of TSP
  \item \code{time.begin.middlethird.se} Standard error for the time at the beginning of the middle third of incubation
  \item \code{time.end.middlethird.se} Standard error for the time at the end of the middle third of incubation
  \item \code{stopattest} NA if stopattest was false, TRUE if at least one incubation series was longer than hatchling size and FALSE at contrary
}
If you indicate new set of temperatures, you must probably also indicate new test values.\cr
Note: three species have predefined embryo stages. embryo.stages parameter can take the values:\cr
\itemize{
  \item \code{Caretta caretta.SCL}
  \item \code{Chelonia mydas.SCL}
  \item \code{Emys orbicularis.SCL}
  \item \code{Emys orbicularis.mass}
  }
The progress bar is based on replicates and timeseries.
}
\details{
Calculate statistics about nests
}
\examples{
\dontrun{
library(embryogrowth)
data(resultNest_4p)
summary.nests <- info.nests(resultNest_4p, out="summary", replicate.CI=20, 
  SE=c(DHA=17.7357362231266, DHH=55.2002231419364, 
  T12H=0.850237694629938, Rho25=8.47868153136681))
  # Result is in summary.nests$summary
infoall <- info.nests(resultNest_4p)
  # Result is a value
infoall.df <- info.nests(resultNest_4p, out="metric", replicate.CI=20, 
  SE=c(DHA=17.7357362231266, DHH=55.2002231419364, 
  T12H=0.850237694629938, Rho25=8.47868153136681)))
# Result is in summary.nests$metric
infoall.both <- info.nests(resultNest_4p, out=c("metric", "summary"), replicate.CI=20, 
  SE=c(DHA=17.7357362231266, DHH=55.2002231419364, 
  T12H=0.850237694629938, Rho25=8.47868153136681)))
# Results are in summary.nests$summary and in summary.nests$metric
}
}
\author{
Marc Girondot
}

