% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.Nests.R
\name{plot.Nests2}
\alias{plot.Nests2}
\title{Show the plot of temperatures with set of nests}
\usage{
\method{plot}{Nests2}(
  x,
  series = "all",
  time = "relative",
  show.heterogeneity = TRUE,
  probs.heterogeneity = c(0.025, 0.5, 0.975),
  col.heterogeneity = rgb(red = 0.2, green = 0.2, blue = 0.2, alpha = 0.6),
  show.legend.names = TRUE,
  show.legend.heterogeneity = TRUE,
  control.legend.heterogeneity = list(),
  control.legend.names = list(),
  col = "black",
  cex.axis = 1,
  xlim = "auto",
  xlab.axis = NULL,
  ...
)
}
\arguments{
\item{x}{Data formated using formatdata.}

\item{series}{Series to be used, logical (TRUE ou FALSE), numbers or names. If "all", all series are used.}

\item{time}{Can be relative or absolute.}

\item{show.heterogeneity}{If TRUE, show the 95\% heterogeneity in grey.}

\item{probs.heterogeneity}{Quantiles of heterogeneity.}

\item{col.heterogeneity}{Color of heterogeneity.}

\item{show.legend.names}{Show a legend for names.}

\item{show.legend.heterogeneity}{Show the heterogeneity legend.}

\item{control.legend.heterogeneity}{The list of parameters for legend of heterogeneity.}

\item{control.legend.names}{The list of parameters for legend of names.}

\item{col}{A recycled vector of colors.}

\item{cex.axis}{The size of x-axis labels}

\item{xlim}{The xlim parameter of plot or can be "auto", "auto-month", or "auto-year"}

\item{xlab.axis}{Labels of x-axis}

\item{...}{Parameters used by plot function}
}
\value{
The position of labels if xaxt="n" is used.
}
\description{
Show the plot of temperatures with set of nests\cr
If time is "absolute", LayingTime must be indicated in FormatNests()\cr
xlim being auto-month used the closest begin and end of month and
auto-year uses the clsest begin and end of year.
}
\details{
plot.Nests2 shows the plot of temperatures for set of nests
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
formated <- FormatNests(nest)
plot(x=formated, series="all", col=rainbow(21))
plot(x=formated, series=1, main="DY.1")
Laying.Time <- matrix(c("DY.1", "15/05/2010", 
                 "DY.17", "24/05/2010", 
                 "DY.16", "24/05/2010", 
                 "DY.18", "25/05/2010", 
                 "DY.20", "25/05/2010", 
                 "DY.21", "26/05/2010", 
                 "DY.22", "26/05/2010", 
                 "DY.23", "26/05/2010", 
                 "DY.24", "27/05/2010", 
                 "DY.25", "27/05/2010", 
                 "DY.28", "28/05/2010", 
                 "DY.26", "28/05/2010", 
                 "DY.27", "28/05/2010", 
                 "DY.146", "20/06/2010", 
                 "DY.147", "20/06/2010", 
                 "DY.172", "24/06/2010", 
                 "DY.175", "24/06/2010", 
                 "DY.170", "24/06/2010", 
                 "DY.260", "06/07/2010", 
                 "DY.282", "12/07/2010", 
                 "DY.310", "18/07/2010", 
                 "DY.309", "18/07/2010", 
                 "DY.328", "25/07/2010", 
                 "DY.331", "26/07/2010"), byrow=TRUE, ncol=2)
tz <- OlsonNames()[grepl("Asia/Istanbul", OlsonNames())]
Laying.Time_f <- as.POSIXlt.character(Laying.Time[, 2], format = "\%d/\%m/\%Y", tz=tz)
names(Laying.Time_f) <- Laying.Time[, 1]
formated <- FormatNests(data=nest, previous=NULL, col.Time="Time", LayingTime=Laying.Time_f)
plot(x=formated, time="absolute", ylim=c(20, 35), 
     col= rainbow(21, alpha = 1), control.legend.heterogeneity=list(cex.0.5))
}
}
\author{
Marc Girondot \email{marc.girondot@universite-paris-saclay.fr}
}
