% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{biomarker_mcc_analysis}
\alias{biomarker_mcc_analysis}
\title{Biomarker analysis based on MCC model classification}
\usage{
biomarker_mcc_analysis(
  model.predictions,
  models.stable.state,
  models.link.operator = NULL,
  observed.synergies,
  threshold,
  num.of.mcc.classes = 5,
  penalty = 0.1
)
}
\arguments{
\item{model.predictions}{a \code{data.frame} object with rows the models and
columns the drug combinations. Possible values for each \emph{model-drug combination
element} are either \emph{0} (no synergy predicted), \emph{1} (synergy was
predicted) or \emph{NA} (couldn't find stable states in either the drug
combination inhibited model or in any of the two single-drug inhibited models).}

\item{models.stable.state}{a \code{data.frame} (nxm) with n models and m nodes.
The row names specify the models' names whereas the column names specify the
network nodes (gene, proteins, etc.). Possible values for each \emph{model-node element}
can be between \emph{0} (inactive node) and \emph{1} (active node) inclusive.
Note that the rows (models) have to be in the same order as in the \code{model.predictions}
parameter.}

\item{models.link.operator}{a \code{data.frame} (nxm) with n models and m nodes. The row
names specify the models' names (same order as in the \code{model.predictions}
parameter) whereas the column names specify
the network nodes (gene, proteins, etc.). Possible values for each
\emph{model-node element} are either \emph{0} (\strong{AND NOT} link operator),
\emph{1} (\strong{OR NOT} link operator) or \emph{0.5} if the node is not targeted
by both activating and inhibiting regulators (no link operator). Default value:
NULL (no analysis on the models parameterization regarding the mutation of the
boolean equation link operator will be done).}

\item{observed.synergies}{a character vector with elements the names of the
drug combinations that were found as synergistic. This should be a subset of
the tested drug combinations, that is the column names of the \code{model.predictions}
parameter.}

\item{threshold}{numeric. A number in the [0,1] interval, above which (or
below its negative value) a biomarker will be registered in the returned result.
Values closer to 1 translate to a more strict threshold and thus less
biomarkers are found.}

\item{num.of.mcc.classes}{numeric. A positive integer larger than 2 that
signifies the number of mcc classes (groups) that we should split the models
MCC values. Default value: 5.}

\item{penalty}{value between 0 and 1 (inclusive). A value of 0 means no
penalty and a value of 1 is the strickest possible penalty. Default value is 0.1.
This penalty is used as part of a weighted term to the difference in a value of
interest (e.g. activity or link operator difference) between two group of
models, to account for the difference in the number of models from each
respective model group.}
}
\value{
a list with various elements:
\itemize{
  \item \code{predicted.synergies}: a character vector of the synergies (drug
  combination names) that were predicted by \strong{at least one} of the models
  in the dataset.
  \item \code{models.mcc}: a numeric vector of MCC scores, one for each model.
  Values are in the [-1,1] interval.
  \item \code{diff.state.mcc.mat}: a matrix whose rows are \strong{vectors of
  average node activity state differences} between two groups of models where
  the classification was based on the \emph{MCC score} of each model and was
  found using an optimal univariate k-means clustering method
  (\code{\link[Ckmeans.1d.dp]{Ckmeans.1d.dp}}).
  Rows represent the different classification group matchings, e.g. (1,2)
  means the models that were classified into the first MCC class vs the models
  that were classified in the 2nd class (higher is better). The columns
  represent the network's node names. Values are in the [-1,1] interval.
  \item \code{biomarkers.mcc.active}: a character vector whose elements are
  the names of the \emph{active state} biomarkers. These nodes appear more
  active in the better performance models.
  \item \code{biomarkers.mcc.inhibited}: a character vector whose elements are
  the names of the \emph{inhibited state} biomarkers. These nodes appear more
  inhibited in the better performance models.
  \item \code{diff.link.mcc.mat}: a matrix whose rows are \strong{vectors of
  average node link operator differences} between two groups of models where
  the classification was based on the \emph{MCC score} of each model and was
  found using an optimal univariate k-means clustering method
  (\code{\link[Ckmeans.1d.dp]{Ckmeans.1d.dp}}).
  Rows represent the different classification group matchings, e.g. (1,2)
  means the models that were classified into the first MCC class vs the models
  that were classified in the 2nd class (higher is better).
  The columns represent the network's node names. Values are in the [-1,1] interval.
  \item \code{biomarkers.mcc.or}: a character vector whose elements are
  the names of the \emph{OR} link operator biomarkers. These nodes have
  mostly the \emph{OR} link operator in their respective boolean equations
  in the better performance models.
  \item \code{biomarkers.mcc.and}: a character vector whose elements are
  the names of the \emph{AND} link operator biomarkers. These nodes have
  mostly the \emph{AND} link operator in their respective boolean equations
  in the better performance models.
}
}
\description{
Use this function to perform a full biomarker analysis on an ensemble boolean model
dataset where the model classification is based on the \emph{Matthews correlation
coefficient score (MCC)}. This analysis enables the discovery of \emph{performance
biomarkers}, nodes whose activity and/or boolean model parameterization (link
operator) affects the prediction performance of the models (as measured by
the MCC score).
}
\seealso{
Other general analysis functions: 
\code{\link{biomarker_synergy_analysis}()},
\code{\link{biomarker_tp_analysis}()}
}
\concept{general analysis functions}
